/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.io.File;
import java.net.URI;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.util.Supplier;

public class NCLogConfigurationFactory
extends ConfigurationFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private NCConfig config;

    public NCLogConfigurationFactory(NCConfig config) {
        this.config = config;
    }

    public Configuration createConfiguration(ConfigurationBuilder<BuiltConfiguration> builder) {
        String nodeId = this.config.getNodeId();
        File logDir = new File(this.config.getLogDir());
        File ncLog = new File(logDir, "nc-" + nodeId + ".log");
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = ncLog::getAbsolutePath;
        LOGGER.warn("logs are being redirected to: {}", supplierArray);
        builder.setStatusLevel(Level.WARN);
        builder.setConfigurationName("RollingBuilder");
        LayoutComponentBuilder defaultLayout = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d{HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n");
        ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("CronTriggeringPolicy").addAttribute("schedule", "0 0 0 * * ?")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "50M"));
        AppenderComponentBuilder defaultRoll = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("default", "RollingFile").addAttribute("fileName", ncLog.getAbsolutePath())).addAttribute("filePattern", new File(logDir, "nc-" + nodeId + "-%d{MM-dd-yy-ss}.log.gz").getAbsolutePath())).add(defaultLayout).addComponent(triggeringPolicy);
        builder.add(defaultRoll);
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef("default")));
        LayoutComponentBuilder accessLayout = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%m%n");
        AppenderComponentBuilder accessRoll = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("access", "RollingFile").addAttribute("fileName", new File(logDir, "access-" + nodeId + ".log").getAbsolutePath())).addAttribute("filePattern", new File(logDir, "access-" + nodeId + "-%d{MM-dd-yy-ss}.log.gz").getAbsolutePath())).add(accessLayout).addComponent(triggeringPolicy);
        builder.add(accessRoll);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.hyracks.http.server.CLFLogger", Level.forName((String)"ACCESS", (int)550)).add(builder.newAppenderRef("access"))).addAttribute("additivity", false));
        LayoutComponentBuilder traceLayout = (LayoutComponentBuilder)((LayoutComponentBuilder)((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%m,%n")).addAttribute("header", "[")).addAttribute("footer", "]");
        AppenderComponentBuilder traceRoll = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("trace", "RollingFile").addAttribute("fileName", (Object)new File(logDir, "trace-" + nodeId + ".log"))).addAttribute("filePattern", (Object)new File(logDir, "trace-" + nodeId + "-%d{MM-dd-yy-ss}.log.gz"))).add(traceLayout).addComponent(triggeringPolicy);
        builder.add(traceRoll);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.hyracks.util.trace.Tracer.Traces", Level.forName((String)"TRACER", (int)570)).add(builder.newAppenderRef("trace"))).addAttribute("additivity", false));
        return (Configuration)builder.build();
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        ConfigurationBuilder builder = NCLogConfigurationFactory.newConfigurationBuilder();
        return this.createConfiguration((ConfigurationBuilder<BuiltConfiguration>)builder);
    }

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public String toString() {
        return "NCLogConfiguration";
    }
}

