/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.S3GuardFsck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3GuardFsckViolationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(S3GuardFsckViolationHandler.class);
    private final S3AFileSystem rawFs;
    private final DynamoDBMetadataStore metadataStore;
    private static String newLine = System.getProperty("line.separator");

    public S3GuardFsckViolationHandler(S3AFileSystem fs, DynamoDBMetadataStore ddbms) {
        this.metadataStore = ddbms;
        this.rawFs = fs;
    }

    public void logError(S3GuardFsck.ComparePair comparePair) throws IOException {
        if (!comparePair.containsViolation()) {
            LOG.debug("There is no violation in the compare pair: {}", (Object)comparePair);
            return;
        }
        StringBuilder sB = new StringBuilder();
        sB.append(newLine).append("On path: ").append(comparePair.getPath()).append(newLine);
        this.handleComparePair(comparePair, sB, HandleMode.LOG);
        LOG.error(sB.toString());
    }

    public void doFix(S3GuardFsck.ComparePair comparePair) throws IOException {
        if (!comparePair.containsViolation()) {
            LOG.debug("There is no violation in the compare pair: {}", (Object)comparePair);
            return;
        }
        StringBuilder sB = new StringBuilder();
        sB.append(newLine).append("On path: ").append(comparePair.getPath()).append(newLine);
        this.handleComparePair(comparePair, sB, HandleMode.FIX);
        LOG.info(sB.toString());
    }

    protected void handleComparePair(S3GuardFsck.ComparePair comparePair, StringBuilder sB, HandleMode handleMode) throws IOException {
        for (S3GuardFsck.Violation violation : comparePair.getViolations()) {
            try {
                ViolationHandler handler = violation.getHandler().getDeclaredConstructor(S3GuardFsck.ComparePair.class).newInstance(comparePair);
                switch (handleMode) {
                    case FIX: {
                        String errorStr = handler.getError();
                        sB.append(errorStr);
                        break;
                    }
                    case LOG: {
                        String fixStr = handler.fixViolation(this.rawFs, this.metadataStore);
                        sB.append(fixStr);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown handleMode: " + (Object)((Object)handleMode));
                    }
                }
            }
            catch (NoSuchMethodException e) {
                LOG.error("Can not find declared constructor for handler: {}", violation.getHandler());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOG.error("Can not instantiate handler: {}", violation.getHandler());
            }
            sB.append(newLine);
        }
    }

    public static class NoLastUpdatedField
    extends ViolationHandler {
        public NoLastUpdatedField(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "No lastUpdated field provided for the entry.";
        }
    }

    public static class OrphanDDBEntry
    extends ViolationHandler {
        public OrphanDDBEntry(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "The DDB entry is orphan - there is no parent in the MS.";
        }

        @Override
        public String fixViolation(S3AFileSystem fs, DynamoDBMetadataStore ddbms) throws IOException {
            Path path = this.getPathMetadata().getFileStatus().getPath();
            ddbms.forgetMetadata(path);
            return String.format("Fixing violation by removing metadata entry from the MS on path: %s", path);
        }
    }

    public static class TombstonedInMsNotDeletedInS3
    extends ViolationHandler {
        public TombstonedInMsNotDeletedInS3(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "The entry for the path is tombstoned in the MS.";
        }
    }

    public static class NoEtag
    extends ViolationHandler {
        public NoEtag(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "No etag.";
        }
    }

    public static class EtagMismatch
    extends ViolationHandler {
        public EtagMismatch(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return String.format("Etag mismatch - S3: %s, MS: %s", this.getS3FileStatus().getETag(), this.getMsFileStatus().getETag());
        }
    }

    public static class VersionIdMismatch
    extends ViolationHandler {
        public VersionIdMismatch(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return String.format("getVersionId mismatch - S3: %s, MS: %s", this.getS3FileStatus().getVersionId(), this.getMsFileStatus().getVersionId());
        }
    }

    public static class ModTimeMismatch
    extends ViolationHandler {
        public ModTimeMismatch(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return String.format("File timestamp mismatch - S3: %s, MS: %s", this.getS3FileStatus().getModificationTime(), this.getMsFileStatus().getModificationTime());
        }
    }

    public static class LengthMismatch
    extends ViolationHandler {
        public LengthMismatch(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return String.format("File length mismatch - S3: %s, MS: %s", this.getS3FileStatus().getLen(), this.getMsFileStatus().getLen());
        }
    }

    public static class AuthDirContentMismatch
    extends ViolationHandler {
        public AuthDirContentMismatch(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            String str = String.format("The content of an authoritative directory listing does not match the content of the S3 listing. S3: %s, MS: %s", Arrays.asList(this.getS3DirListing()), this.getMsDirListing().getListing());
            return str;
        }
    }

    public static class FileInS3DirInMs
    extends ViolationHandler {
        public FileInS3DirInMs(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "A file in S3 is a directory entry in the MS";
        }
    }

    public static class DirInS3FileInMs
    extends ViolationHandler {
        public DirInS3FileInMs(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "A directory in S3 is a file entry in the MS";
        }
    }

    public static class ParentTombstoned
    extends ViolationHandler {
        public ParentTombstoned(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "The entry in the metastore database has a parent entry which is a tombstone marker";
        }
    }

    public static class ParentIsAFile
    extends ViolationHandler {
        public ParentIsAFile(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "The entry's parent in the metastore database is a file.";
        }
    }

    public static class NoParentEntry
    extends ViolationHandler {
        public NoParentEntry(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "Entry does not have a parent entry (not root)";
        }
    }

    public static class NoMetadataEntry
    extends ViolationHandler {
        public NoMetadataEntry(S3GuardFsck.ComparePair comparePair) {
            super(comparePair);
        }

        @Override
        public String getError() {
            return "No PathMetadata for this path in the MS.";
        }
    }

    public static abstract class ViolationHandler {
        private final PathMetadata pathMetadata;
        private final S3AFileStatus s3FileStatus;
        private final S3AFileStatus msFileStatus;
        private final List<FileStatus> s3DirListing;
        private final DirListingMetadata msDirListing;

        public ViolationHandler(S3GuardFsck.ComparePair comparePair) {
            this.pathMetadata = comparePair.getMsPathMetadata();
            this.s3FileStatus = comparePair.getS3FileStatus();
            this.msFileStatus = this.pathMetadata != null ? this.pathMetadata.getFileStatus() : null;
            this.s3DirListing = comparePair.getS3DirListing();
            this.msDirListing = comparePair.getMsDirListing();
        }

        public abstract String getError();

        public PathMetadata getPathMetadata() {
            return this.pathMetadata;
        }

        public S3AFileStatus getS3FileStatus() {
            return this.s3FileStatus;
        }

        public S3AFileStatus getMsFileStatus() {
            return this.msFileStatus;
        }

        public List<FileStatus> getS3DirListing() {
            return this.s3DirListing;
        }

        public DirListingMetadata getMsDirListing() {
            return this.msDirListing;
        }

        public String fixViolation(S3AFileSystem fs, DynamoDBMetadataStore ddbms) throws IOException {
            return String.format("Fixing of violation: %s is not supported yet.", this.getClass().getSimpleName());
        }
    }

    public static enum HandleMode {
        FIX,
        LOG;

    }
}

