/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.api.exceptions.ErrorCode;

public class LeftOuterUnnestMapOperator
extends AbstractUnnestMapOperator {
    private IAlgebricksConstantValue missingValue;

    public LeftOuterUnnestMapOperator(List<LogicalVariable> variables, Mutable<ILogicalExpression> expression, List<Object> variableTypes, IAlgebricksConstantValue missingValue) {
        super(variables, expression, variableTypes, true);
        this.setMissingValue(missingValue);
    }

    public IAlgebricksConstantValue getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(IAlgebricksConstantValue missingValue) {
        this.missingValue = LeftOuterUnnestMapOperator.validateMissingValue(missingValue);
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.LEFT_OUTER_UNNEST_MAP;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitLeftOuterUnnestMapOperator(this, arg);
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        PropagatingTypeEnvironment env = this.createPropagatingAllInputsTypeEnvironment(ctx);
        for (int i = 0; i < this.variables.size(); ++i) {
            Object outVarType;
            Object varType = this.variableTypes.get(i);
            if (this.missingValue.isMissing()) {
                outVarType = ctx.getMissableTypeComputer().makeMissableType(varType);
            } else if (this.missingValue.isNull()) {
                outVarType = ctx.getMissableTypeComputer().makeNullableType(varType);
            } else {
                throw new AlgebricksException(ErrorCode.ILLEGAL_STATE, this.getSourceLocation(), new Serializable[]{""});
            }
            env.setVarType((LogicalVariable)this.variables.get(i), outVarType);
        }
        return env;
    }

    private static IAlgebricksConstantValue validateMissingValue(IAlgebricksConstantValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.isMissing()) {
            return ConstantExpression.MISSING.getValue();
        }
        if (value.isNull()) {
            return ConstantExpression.NULL.getValue();
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }
}

