/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.deployment.DeploymentRun;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.IPCResponder;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class CliDeployBinaryWork
extends SynchronizableWork {
    private ClusterControllerService ccs;
    private List<URL> binaryURLs;
    private DeploymentId deploymentId;
    private IPCResponder<DeploymentId> callback;

    public CliDeployBinaryWork(ClusterControllerService ncs, List<URL> binaryURLs, DeploymentId deploymentId, IPCResponder<DeploymentId> callback) {
        this.ccs = ncs;
        this.binaryURLs = binaryURLs;
        this.deploymentId = deploymentId;
        this.callback = callback;
    }

    public void doRun() {
        try {
            if (this.deploymentId == null) {
                this.deploymentId = new DeploymentId(UUID.randomUUID().toString());
            }
            DeploymentUtils.deploy((DeploymentId)this.deploymentId, this.binaryURLs, (ConcurrentMap)this.ccs.getContext().getJobSerializerDeserializerContainer(), (ServerContext)this.ccs.getServerContext(), (boolean)false);
            INodeManager nodeManager = this.ccs.getNodeManager();
            Collection<String> nodeIds = nodeManager.getAllNodeIds();
            final DeploymentRun dRun = new DeploymentRun(nodeIds);
            this.ccs.addDeploymentRun(this.deploymentId, dRun);
            for (NodeControllerState ncs : nodeManager.getAllNodeControllerStates()) {
                ncs.getNodeController().deployBinary(this.deploymentId, this.binaryURLs);
            }
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        dRun.waitForCompletion();
                        CliDeployBinaryWork.this.ccs.removeDeploymentRun(CliDeployBinaryWork.this.deploymentId);
                        CliDeployBinaryWork.this.callback.setValue((Object)CliDeployBinaryWork.this.deploymentId);
                    }
                    catch (Exception e) {
                        CliDeployBinaryWork.this.callback.setException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

