/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.AbstractCallExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.MissingLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.util.ViewUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.SqlppFunctionBodyRewriter;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.GenerateColumnNameVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineColumnAliasVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineWithExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.OperatorExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SelectExcludeRewriteSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SetOperationVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlCompatRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppCaseAggregateExtractionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppCaseExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppFunctionCallResolverVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGatherFunctionCallsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupingSetsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppInlineUdfsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppListInputFunctionRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppRightJoinRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppSpecialFunctionNameRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppWindowAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppWindowRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SubstituteGroupbyExpressionWithVariableVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.VariableCheckAndRewriteVisitor;
import org.apache.asterix.lang.sqlpp.util.SqlppAstPrintUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.metadata.bootstrap.MetadataBuiltinEntities;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.ViewDetails;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlppQueryRewriter
implements IQueryRewriter {
    private static final Logger LOGGER = LogManager.getLogger(SqlppQueryRewriter.class);
    public static final String INLINE_WITH_OPTION = "inline_with";
    private static final boolean INLINE_WITH_OPTION_DEFAULT = true;
    public static final String SQL_COMPAT_OPTION = "sql_compat";
    private static final boolean SQL_COMPAT_OPTION_DEFAULT = false;
    private final IParserFactory parserFactory;
    private SqlppFunctionBodyRewriter functionAndViewBodyRewriter;
    private IReturningStatement topStatement;
    private LangRewritingContext context;
    private MetadataProvider metadataProvider;
    private Collection<VarIdentifier> externalVars;
    private boolean allowNonStoredUdfCalls;
    private boolean inlineUdfsAndViews;
    private boolean isLogEnabled;

    public SqlppQueryRewriter(IParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    protected void setup(LangRewritingContext context, IReturningStatement topStatement, Collection<VarIdentifier> externalVars, boolean allowNonStoredUdfCalls, boolean inlineUdfsAndViews) throws CompilationException {
        this.context = context;
        this.metadataProvider = context.getMetadataProvider();
        this.topStatement = topStatement;
        this.externalVars = externalVars != null ? externalVars : Collections.emptyList();
        this.allowNonStoredUdfCalls = allowNonStoredUdfCalls;
        this.inlineUdfsAndViews = inlineUdfsAndViews;
        this.isLogEnabled = LOGGER.isTraceEnabled();
        this.logExpression("Starting AST rewrites on", "");
    }

    public void rewrite(LangRewritingContext context, IReturningStatement topStatement, boolean allowNonStoredUdfCalls, boolean inlineUdfsAndViews, Collection<VarIdentifier> externalVars) throws CompilationException {
        this.setup(context, topStatement, externalVars, allowNonStoredUdfCalls, inlineUdfsAndViews);
        this.resolveFunctionCalls();
        this.generateColumnNames();
        this.rewriteSqlCompat();
        this.substituteGroupbyKeyExpression();
        this.rewriteGroupBys();
        this.rewriteSetOperations();
        this.inlineColumnAlias();
        this.rewriteSelectExcludeSugar();
        this.rewriteWindowExpressions();
        this.rewriteGroupingSets();
        this.variableCheckAndRewrite();
        this.extractAggregatesFromCaseExpressions();
        this.rewriteGroupByAggregationSugar();
        this.rewriteWindowAggregationSugar();
        this.rewriteOperatorExpression();
        this.rewriteCaseExpressions();
        this.rewriteListInputFunctions();
        this.rewriteRightJoins();
        this.loadAndInlineUdfsAndViews();
        this.rewriteSpecialFunctionNames();
        this.inlineWithExpressions();
        topStatement.setVarCounter(context.getVarCounter().get());
    }

    protected void rewriteGroupByAggregationSugar() throws CompilationException {
        SqlppGroupByAggregationSugarVisitor visitor = new SqlppGroupByAggregationSugarVisitor(this.context, this.externalVars);
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteListInputFunctions() throws CompilationException {
        SqlppListInputFunctionRewriteVisitor listInputFunctionVisitor = new SqlppListInputFunctionRewriteVisitor();
        this.rewriteTopExpr(listInputFunctionVisitor, null);
    }

    protected void rewriteSqlCompat() throws CompilationException {
        boolean sqlCompatMode = this.metadataProvider.getBooleanProperty(SQL_COMPAT_OPTION, false);
        if (!sqlCompatMode) {
            return;
        }
        SqlCompatRewriteVisitor visitor = new SqlCompatRewriteVisitor(this.context);
        this.rewriteTopExpr(visitor, null);
    }

    protected void resolveFunctionCalls() throws CompilationException {
        SqlppFunctionCallResolverVisitor visitor = new SqlppFunctionCallResolverVisitor(this.context, this.allowNonStoredUdfCalls);
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteSpecialFunctionNames() throws CompilationException {
        SqlppSpecialFunctionNameRewriteVisitor visitor = new SqlppSpecialFunctionNameRewriteVisitor();
        this.rewriteTopExpr(visitor, null);
    }

    protected void inlineWithExpressions() throws CompilationException {
        if (!this.metadataProvider.getBooleanProperty(INLINE_WITH_OPTION, true)) {
            return;
        }
        InlineWithExpressionVisitor inlineWithExpressionVisitor = new InlineWithExpressionVisitor(this.context, this.metadataProvider);
        this.rewriteTopExpr(inlineWithExpressionVisitor, null);
    }

    protected void generateColumnNames() throws CompilationException {
        GenerateColumnNameVisitor generateColumnNameVisitor = new GenerateColumnNameVisitor(this.context);
        this.rewriteTopExpr(generateColumnNameVisitor, null);
    }

    protected void substituteGroupbyKeyExpression() throws CompilationException {
        SubstituteGroupbyExpressionWithVariableVisitor substituteGbyExprVisitor = new SubstituteGroupbyExpressionWithVariableVisitor(this.context);
        this.rewriteTopExpr(substituteGbyExprVisitor, null);
    }

    protected void rewriteSetOperations() throws CompilationException {
        SetOperationVisitor setOperationVisitor = new SetOperationVisitor(this.context);
        this.rewriteTopExpr(setOperationVisitor, null);
    }

    protected void rewriteOperatorExpression() throws CompilationException {
        OperatorExpressionVisitor operatorExpressionVisitor = new OperatorExpressionVisitor(this.context);
        this.rewriteTopExpr(operatorExpressionVisitor, null);
    }

    protected void inlineColumnAlias() throws CompilationException {
        InlineColumnAliasVisitor inlineColumnAliasVisitor = new InlineColumnAliasVisitor(this.context);
        this.rewriteTopExpr(inlineColumnAliasVisitor, null);
    }

    protected void variableCheckAndRewrite() throws CompilationException {
        VariableCheckAndRewriteVisitor variableCheckAndRewriteVisitor = new VariableCheckAndRewriteVisitor(this.context, this.metadataProvider, this.externalVars);
        this.rewriteTopExpr(variableCheckAndRewriteVisitor, null);
    }

    protected void rewriteGroupBys() throws CompilationException {
        SqlppGroupByVisitor groupByVisitor = new SqlppGroupByVisitor(this.context);
        this.rewriteTopExpr(groupByVisitor, null);
    }

    protected void rewriteGroupingSets() throws CompilationException {
        SqlppGroupingSetsVisitor groupingSetsVisitor = new SqlppGroupingSetsVisitor(this.context);
        this.rewriteTopExpr(groupingSetsVisitor, null);
    }

    protected void rewriteWindowExpressions() throws CompilationException {
        SqlppWindowRewriteVisitor windowVisitor = new SqlppWindowRewriteVisitor(this.context);
        this.rewriteTopExpr(windowVisitor, null);
    }

    protected void rewriteWindowAggregationSugar() throws CompilationException {
        SqlppWindowAggregationSugarVisitor windowVisitor = new SqlppWindowAggregationSugarVisitor(this.context);
        this.rewriteTopExpr(windowVisitor, null);
    }

    protected void extractAggregatesFromCaseExpressions() throws CompilationException {
        SqlppCaseAggregateExtractionVisitor visitor = new SqlppCaseAggregateExtractionVisitor(this.context);
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteCaseExpressions() throws CompilationException {
        SqlppCaseExpressionVisitor visitor = new SqlppCaseExpressionVisitor();
        this.rewriteTopExpr(visitor, null);
    }

    protected void rewriteRightJoins() throws CompilationException {
        SqlppRightJoinRewriteVisitor visitor = new SqlppRightJoinRewriteVisitor(this.context, this.externalVars);
        this.rewriteTopExpr(visitor, null);
    }

    protected void loadAndInlineUdfsAndViews() throws CompilationException {
        Pair<Map<FunctionSignature, FunctionDecl>, Map<DatasetFullyQualifiedName, ViewDecl>> udfAndViewDecls = this.loadUdfsAndViews(this.topStatement);
        Map udfs = (Map)udfAndViewDecls.first;
        Map views = (Map)udfAndViewDecls.second;
        if (udfs.isEmpty() && views.isEmpty()) {
            return;
        }
        if (ExpressionUtils.hasFunctionOrViewRecursion((Map)udfs, (Map)views, SqlppGatherFunctionCallsVisitor::new)) {
            throw new CompilationException(ErrorCode.ILLEGAL_FUNCTION_OR_VIEW_RECURSION, this.topStatement.getSourceLocation(), new Serializable[0]);
        }
        if (this.inlineUdfsAndViews) {
            SqlppInlineUdfsVisitor visitor = new SqlppInlineUdfsVisitor(this.context, udfs, views);
            while (this.rewriteTopExpr(visitor, null).booleanValue()) {
            }
        }
    }

    protected void rewriteSelectExcludeSugar() throws CompilationException {
        SelectExcludeRewriteSugarVisitor selectExcludeRewriteSugarVisitor = new SelectExcludeRewriteSugarVisitor(this.context);
        this.rewriteTopExpr(selectExcludeRewriteSugarVisitor, null);
    }

    private <R, T> R rewriteTopExpr(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        Object result = this.topStatement.accept(visitor, arg);
        this.logExpression(">>>> AST After", visitor.getClass().getSimpleName());
        return (R)result;
    }

    private void logExpression(String p0, String p1) throws CompilationException {
        if (this.isLogEnabled) {
            LOGGER.trace("{} {}\n{}", (Object)p0, (Object)p1, (Object)LogRedactionUtil.userData((String)SqlppAstPrintUtil.toString((ILangExpression)this.topStatement)));
        }
    }

    public void getFunctionCalls(Expression expression, Collection<? super AbstractCallExpression> outCalls) throws CompilationException {
        SqlppGatherFunctionCallsVisitor gfc = new SqlppGatherFunctionCallsVisitor(outCalls);
        expression.accept((ILangVisitor)gfc, null);
    }

    public Set<VariableExpr> getExternalVariables(Expression expr) throws CompilationException {
        Set<VariableExpr> freeVars = SqlppVariableUtil.getFreeVariables((ILangExpression)expr);
        HashSet<VariableExpr> extVars = new HashSet<VariableExpr>();
        for (VariableExpr ve : freeVars) {
            if (!SqlppVariableUtil.isExternalVariableReference(ve)) continue;
            extVars.add(ve);
        }
        return extVars;
    }

    public VarIdentifier toExternalVariableName(String statementParameterName) {
        return SqlppVariableUtil.toExternalVariableIdentifier(statementParameterName);
    }

    public String toFunctionParameterName(VarIdentifier paramVar) {
        return SqlppVariableUtil.toUserDefinedName(paramVar.getValue());
    }

    private Pair<Map<FunctionSignature, FunctionDecl>, Map<DatasetFullyQualifiedName, ViewDecl>> loadUdfsAndViews(IReturningStatement topExpr) throws CompilationException {
        AbstractCallExpression fnCall;
        LinkedHashMap<FunctionSignature, FunctionDecl> udfs = new LinkedHashMap<FunctionSignature, FunctionDecl>();
        LinkedHashMap<DatasetFullyQualifiedName, ViewDecl> views = new LinkedHashMap<DatasetFullyQualifiedName, ViewDecl>();
        ArrayDeque workQueue = new ArrayDeque();
        SqlppGatherFunctionCallsVisitor callVisitor = new SqlppGatherFunctionCallsVisitor(workQueue);
        for (Expression expr : topExpr.getDirectlyEnclosedExpressions()) {
            expr.accept((ILangVisitor)callVisitor, null);
        }
        block5: while ((fnCall = (AbstractCallExpression)workQueue.poll()) != null) {
            switch (fnCall.getKind()) {
                case CALL_EXPRESSION: {
                    FunctionDecl fd;
                    FunctionSignature fs = fnCall.getFunctionSignature();
                    DataverseName fsDataverse = fs.getDataverseName();
                    if (fsDataverse == null) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, fnCall.getSourceLocation(), new Serializable[]{fs});
                    }
                    if (FunctionUtil.isBuiltinFunctionSignature((FunctionSignature)fs)) {
                        DatasetFullyQualifiedName viewName;
                        if (!FunctionUtil.isBuiltinDatasetFunction((FunctionSignature)fs)) continue block5;
                        Triple dsArgs = FunctionUtil.parseDatasetFunctionArguments((AbstractCallExpression)fnCall);
                        if (!Boolean.TRUE.equals(dsArgs.second) || views.containsKey(viewName = (DatasetFullyQualifiedName)dsArgs.first)) continue block5;
                        ViewDecl viewDecl = this.fetchViewDecl(viewName, fnCall.getSourceLocation());
                        views.put(viewName, viewDecl);
                        viewDecl.getNormalizedViewBody().accept((ILangVisitor)callVisitor, null);
                        continue block5;
                    }
                    if (udfs.containsKey(fs) || (fd = this.fetchFunctionDecl(fs, fnCall.getSourceLocation())) == null) continue block5;
                    udfs.put(fs, fd);
                    fd.getNormalizedFuncBody().accept((ILangVisitor)callVisitor, null);
                    continue block5;
                }
                case WINDOW_EXPRESSION: {
                    continue block5;
                }
            }
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, fnCall.getSourceLocation(), new Serializable[]{fnCall.getFunctionSignature().toString(false)});
        }
        return new Pair(udfs, views);
    }

    private FunctionDecl fetchFunctionDecl(FunctionSignature fs, SourceLocation sourceLoc) throws CompilationException {
        Expression normBody;
        FunctionDecl fd = (FunctionDecl)this.context.getDeclaredFunctions().get(fs);
        if (fd == null) {
            Function function;
            try {
                function = this.metadataProvider.lookupUserDefinedFunction(fs);
            }
            catch (AlgebricksException e) {
                throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, sourceLoc, new Serializable[]{fs.toString()});
            }
            if (function == null) {
                throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, sourceLoc, new Serializable[]{fs.toString()});
            }
            if (function.isExternal()) {
                return null;
            }
            fd = FunctionUtil.parseStoredFunction((Function)function, (IParserFactory)this.parserFactory, (IWarningCollector)this.context.getWarningCollector(), (SourceLocation)sourceLoc);
        }
        if ((normBody = fd.getNormalizedFuncBody()) == null) {
            normBody = this.rewriteFunctionBody(fd);
            fd.setNormalizedFuncBody(normBody);
        }
        return fd;
    }

    private ViewDecl fetchViewDecl(DatasetFullyQualifiedName viewName, SourceLocation sourceLoc) throws CompilationException {
        Expression normBody;
        IAType viewItemType = null;
        Boolean defaultNull = false;
        Triple temporalDataFormat = null;
        ViewDecl viewDecl = (ViewDecl)this.context.getDeclaredViews().get(viewName);
        if (viewDecl == null) {
            boolean isAnyType;
            Dataset dataset;
            try {
                dataset = this.metadataProvider.findDataset(viewName.getDataverseName(), viewName.getDatasetName(), true);
            }
            catch (AlgebricksException e) {
                throw new CompilationException(ErrorCode.UNKNOWN_VIEW, (Throwable)e, sourceLoc, new Serializable[]{viewName});
            }
            if (dataset == null || DatasetUtil.isNotView((Dataset)dataset)) {
                throw new CompilationException(ErrorCode.UNKNOWN_VIEW, sourceLoc, new Serializable[]{viewName});
            }
            ViewDetails viewDetails = (ViewDetails)dataset.getDatasetDetails();
            viewDecl = ViewUtil.parseStoredView((DatasetFullyQualifiedName)viewName, (ViewDetails)viewDetails, (IParserFactory)this.parserFactory, (IWarningCollector)this.context.getWarningCollector(), (SourceLocation)sourceLoc);
            DataverseName itemTypeDataverseName = dataset.getItemTypeDataverseName();
            String itemTypeName = dataset.getItemTypeName();
            boolean bl = isAnyType = MetadataBuiltinEntities.ANY_OBJECT_DATATYPE.getDataverseName().equals((Object)itemTypeDataverseName) && MetadataBuiltinEntities.ANY_OBJECT_DATATYPE.getDatatypeName().equals(itemTypeName);
            if (!isAnyType) {
                try {
                    viewItemType = this.metadataProvider.findType(itemTypeDataverseName, itemTypeName);
                }
                catch (AlgebricksException e) {
                    throw new CompilationException(ErrorCode.UNKNOWN_TYPE, new Serializable[]{TypeUtil.getFullyQualifiedDisplayName((DataverseName)itemTypeDataverseName, (String)itemTypeName)});
                }
                defaultNull = viewDetails.getDefaultNull();
                temporalDataFormat = new Triple((Object)viewDetails.getDatetimeFormat(), (Object)viewDetails.getDateFormat(), (Object)viewDetails.getTimeFormat());
            }
        }
        if ((normBody = viewDecl.getNormalizedViewBody()) == null) {
            normBody = this.rewriteViewBody(viewDecl, viewItemType, defaultNull, temporalDataFormat);
            viewDecl.setNormalizedViewBody(normBody);
        }
        return viewDecl;
    }

    private Expression rewriteFunctionBody(FunctionDecl fnDecl) throws CompilationException {
        FunctionSignature fs = fnDecl.getSignature();
        return this.rewriteFunctionOrViewBody(fs.getDataverseName(), fs, fnDecl.getFuncBody(), fnDecl.getParamList(), !fnDecl.isStored(), fnDecl.getSourceLocation());
    }

    private Expression rewriteViewBody(ViewDecl viewDecl, IAType viewItemType, Boolean defaultNull, Triple<String, String, String> temporalDataFormat) throws CompilationException {
        DatasetFullyQualifiedName viewName = viewDecl.getViewName();
        SourceLocation sourceLoc = viewDecl.getSourceLocation();
        Expression rewrittenBodyExpr = this.rewriteFunctionOrViewBody(viewName.getDataverseName(), viewName, viewDecl.getViewBody(), Collections.emptyList(), false, sourceLoc);
        if (viewItemType != null) {
            if (!Boolean.TRUE.equals(defaultNull)) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{"Default Null is required"});
            }
            rewrittenBodyExpr = SqlppFunctionBodyRewriter.castViewBodyAsType(this.context, rewrittenBodyExpr, viewItemType, temporalDataFormat, viewName, sourceLoc);
        }
        return rewrittenBodyExpr;
    }

    private Expression rewriteFunctionOrViewBody(DataverseName entityDataverseName, Object entityDisplayName, Expression bodyExpr, List<VarIdentifier> externalVars, boolean allowNonStoredUdfCalls, SourceLocation sourceLoc) throws CompilationException {
        Dataverse targetDataverse;
        Dataverse defaultDataverse = this.metadataProvider.getDefaultDataverse();
        if (entityDataverseName == null || entityDataverseName.equals((Object)defaultDataverse.getDataverseName())) {
            targetDataverse = defaultDataverse;
        } else {
            try {
                targetDataverse = this.metadataProvider.findDataverse(entityDataverseName);
            }
            catch (AlgebricksException e) {
                throw new CompilationException(ErrorCode.UNKNOWN_DATAVERSE, (Throwable)e, sourceLoc, new Serializable[]{entityDataverseName});
            }
        }
        this.metadataProvider.setDefaultDataverse(targetDataverse);
        try {
            Query wrappedQuery = ExpressionUtils.createWrappedQuery((Expression)bodyExpr, (SourceLocation)sourceLoc);
            this.getFunctionAndViewBodyRewriter().rewrite(this.context, (IReturningStatement)wrappedQuery, allowNonStoredUdfCalls, false, externalVars);
            Expression expression = wrappedQuery.getBody();
            return expression;
        }
        catch (CompilationException e) {
            throw new CompilationException(ErrorCode.COMPILATION_BAD_FUNCTION_DEFINITION, (Throwable)e, new Serializable[]{entityDisplayName.toString(), e.getMessage()});
        }
        finally {
            this.metadataProvider.setDefaultDataverse(defaultDataverse);
        }
    }

    protected SqlppFunctionBodyRewriter getFunctionAndViewBodyRewriter() {
        if (this.functionAndViewBodyRewriter == null) {
            this.functionAndViewBodyRewriter = new SqlppFunctionBodyRewriter(this.parserFactory);
        }
        return this.functionAndViewBodyRewriter;
    }

    public Query createFunctionAccessorQuery(FunctionDecl functionDecl) {
        FunctionSignature functionSignature = functionDecl.getSignature();
        int arity = functionSignature.getArity();
        List args = arity == -1 ? Collections.emptyList() : Collections.nCopies(arity, new LiteralExpr((Literal)MissingLiteral.INSTANCE));
        CallExpr fcall = new CallExpr(functionSignature, args);
        fcall.setSourceLocation(functionDecl.getSourceLocation());
        return ExpressionUtils.createWrappedQuery((Expression)fcall, (SourceLocation)functionDecl.getSourceLocation());
    }

    public Query createViewAccessorQuery(ViewDecl viewDecl) {
        DataverseName dataverseName = viewDecl.getViewName().getDataverseName();
        String viewName = viewDecl.getViewName().getDatasetName();
        Expression vAccessExpr = SqlppQueryRewriter.createDatasetAccessExpression(dataverseName, viewName, viewDecl.getSourceLocation());
        return ExpressionUtils.createWrappedQuery((Expression)vAccessExpr, (SourceLocation)viewDecl.getSourceLocation());
    }

    private static Expression createDatasetAccessExpression(DataverseName dataverseName, String datasetName, SourceLocation sourceLoc) {
        FieldAccessor resultExpr = null;
        List dataverseNameParts = dataverseName.getParts();
        int n = dataverseNameParts.size();
        for (int i = 0; i < n; ++i) {
            String part = (String)dataverseNameParts.get(i);
            resultExpr = i == 0 ? new VariableExpr(new VarIdentifier(SqlppVariableUtil.toInternalVariableName(part))) : new FieldAccessor((Expression)resultExpr, new Identifier(part));
            resultExpr.setSourceLocation(sourceLoc);
        }
        resultExpr = new FieldAccessor(resultExpr, new Identifier(datasetName));
        resultExpr.setSourceLocation(sourceLoc);
        return resultExpr;
    }
}

