/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.sort;

import java.util.List;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.sort.ExternalSortGroupByRunGenerator;
import org.apache.hyracks.dataflow.std.group.sort.ExternalSortGroupByRunMerger;
import org.apache.hyracks.dataflow.std.sort.AbstractExternalSortRunMerger;
import org.apache.hyracks.dataflow.std.sort.AbstractSorterOperatorDescriptor;
import org.apache.hyracks.dataflow.std.sort.Algorithm;
import org.apache.hyracks.dataflow.std.sort.IRunGenerator;

public class SortGroupByOperatorDescriptor
extends AbstractSorterOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int[] groupFields;
    private final IAggregatorDescriptorFactory mergeAggregatorFactory;
    private final IAggregatorDescriptorFactory partialAggregatorFactory;
    private final RecordDescriptor partialAggRecordDesc;
    private final RecordDescriptor outputRecordDesc;
    private final boolean finalStage;
    private static final Algorithm ALG = Algorithm.MERGE_SORT;

    public SortGroupByOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, int[] groupFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory partialAggregatorFactory, IAggregatorDescriptorFactory mergeAggregatorFactory, RecordDescriptor partialAggRecordDesc, RecordDescriptor outRecordDesc, boolean finalStage) {
        INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray;
        if (firstKeyNormalizerFactory != null) {
            INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray2 = new INormalizedKeyComputerFactory[1];
            iNormalizedKeyComputerFactoryArray = iNormalizedKeyComputerFactoryArray2;
            iNormalizedKeyComputerFactoryArray2[0] = firstKeyNormalizerFactory;
        } else {
            iNormalizedKeyComputerFactoryArray = null;
        }
        this(spec, framesLimit, sortFields, groupFields, iNormalizedKeyComputerFactoryArray, comparatorFactories, partialAggregatorFactory, mergeAggregatorFactory, partialAggRecordDesc, outRecordDesc, finalStage);
    }

    public SortGroupByOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, int[] groupFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory partialAggregatorFactory, IAggregatorDescriptorFactory mergeAggregatorFactory, RecordDescriptor partialAggRecordDesc, RecordDescriptor outRecordDesc, boolean finalStage) {
        super(spec, framesLimit, sortFields, keyNormalizerFactories, comparatorFactories, outRecordDesc);
        if (framesLimit <= 1) {
            throw new IllegalStateException();
        }
        this.groupFields = groupFields;
        this.mergeAggregatorFactory = mergeAggregatorFactory;
        this.partialAggregatorFactory = partialAggregatorFactory;
        this.partialAggRecordDesc = partialAggRecordDesc;
        this.outputRecordDesc = outRecordDesc;
        this.finalStage = finalStage;
    }

    @Override
    public AbstractSorterOperatorDescriptor.SortActivity getSortActivity(ActivityId id) {
        return new AbstractSorterOperatorDescriptor.SortActivity(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected IRunGenerator getRunGenerator(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescriptorProvider) throws HyracksDataException {
                ExternalSortGroupByRunGenerator runGen = new ExternalSortGroupByRunGenerator(ctx, SortGroupByOperatorDescriptor.this.sortFields, recordDescriptorProvider.getInputRecordDescriptor(this.getActivityId(), 0), SortGroupByOperatorDescriptor.this.framesLimit, SortGroupByOperatorDescriptor.this.groupFields, SortGroupByOperatorDescriptor.this.keyNormalizerFactories, SortGroupByOperatorDescriptor.this.comparatorFactories, SortGroupByOperatorDescriptor.this.partialAggregatorFactory, SortGroupByOperatorDescriptor.this.partialAggRecordDesc, ALG);
                return runGen;
            }
        };
    }

    @Override
    public AbstractSorterOperatorDescriptor.MergeActivity getMergeActivity(ActivityId id) {
        return new AbstractSorterOperatorDescriptor.MergeActivity(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected AbstractExternalSortRunMerger getSortRunMerger(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, List<GeneratedRunFileReader> runs, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, int necessaryFrames) {
                return new ExternalSortGroupByRunMerger(ctx, runs, SortGroupByOperatorDescriptor.this.sortFields, recordDescProvider.getInputRecordDescriptor(new ActivityId(SortGroupByOperatorDescriptor.this.odId, 0), 0), SortGroupByOperatorDescriptor.this.partialAggRecordDesc, SortGroupByOperatorDescriptor.this.outputRecordDesc, necessaryFrames, SortGroupByOperatorDescriptor.this.groupFields, nmkComputer, comparators, SortGroupByOperatorDescriptor.this.partialAggregatorFactory, SortGroupByOperatorDescriptor.this.mergeAggregatorFactory, !SortGroupByOperatorDescriptor.this.finalStage);
            }
        };
    }

    @Override
    public String getDisplayName() {
        return "GroupBy (Sort)";
    }

    public String toString() {
        return this.getDisplayName();
    }
}

