/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record;

import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class RecordWithPK<T>
implements IRawRecord<T> {
    protected final ArrayBackedValueStorage[] pkFieldValueBuffers;
    protected final int[] pkIndexes;
    protected final IAType[] keyTypes;
    protected IRawRecord<T> record;

    public RecordWithPK(IRawRecord<T> record, IAType[] pkTypes, int[] pkIndexes) {
        this.record = record;
        this.keyTypes = pkTypes;
        this.pkIndexes = pkIndexes;
        this.pkFieldValueBuffers = this.keyTypes != null ? new ArrayBackedValueStorage[pkTypes.length] : null;
    }

    public RecordWithPK(IRawRecord<T> rawRecord, ArrayBackedValueStorage[] pkFieldValueBuffers) {
        this.record = rawRecord;
        this.keyTypes = null;
        this.pkIndexes = null;
        this.pkFieldValueBuffers = pkFieldValueBuffers;
    }

    public ArrayBackedValueStorage[] getPKs() {
        return this.pkFieldValueBuffers;
    }

    @Override
    public byte[] getBytes() {
        return this.record.getBytes();
    }

    @Override
    public T get() {
        return this.record.get();
    }

    public IRawRecord<? extends T> getRecord() {
        return this.record;
    }

    @Override
    public void reset() {
        this.record.reset();
        for (ArrayBackedValueStorage pkStorage : this.pkFieldValueBuffers) {
            pkStorage.reset();
        }
    }

    @Override
    public int size() {
        return this.record.size();
    }

    @Override
    public void set(T t) {
        this.record.set(t);
    }

    public void appendPrimaryKeyToTuple(ArrayTupleBuilder tb) throws HyracksDataException {
        for (ArrayBackedValueStorage pkStorage : this.pkFieldValueBuffers) {
            tb.addField((IValueReference)pkStorage);
        }
    }

    @Override
    public void set(IRawRecord<? extends T> record) {
        this.record.set(record.get());
    }
}

