/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.hash;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.dataflow.data.common.ListAccessorUtil;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.om.pointables.nonvisitor.RecordField;
import org.apache.asterix.om.pointables.nonvisitor.SortedRecord;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.FloatToDoubleTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToDoubleTypeConvertComputer;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.om.util.container.ObjectFactories;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.MurmurHash3BinaryHash;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class AMurmurHash3BinaryHashFunctionFamily
implements IBinaryHashFunctionFamily {
    private static final long serialVersionUID = 1L;
    private final IAType type;

    public AMurmurHash3BinaryHashFunctionFamily(IAType type) {
        this.type = type;
    }

    public static IBinaryHashFunction createBinaryHashFunction(IAType type, int seed) {
        return new GenericHashFunction(type, seed);
    }

    public IBinaryHashFunction createBinaryHashFunction(int seed) {
        return new GenericHashFunction(this.type, seed);
    }

    private static final class GenericHashFunction
    implements IBinaryHashFunction {
        private final ArrayBackedValueStorage valueBuffer = new ArrayBackedValueStorage();
        private final DataOutput valueOut = this.valueBuffer.getDataOutput();
        private final IObjectPool<IPointable, Void> voidPointableAllocator = new ListObjectPool<IPointable, Void>(ObjectFactories.VOID_FACTORY);
        private final IObjectPool<IMutableValueStorage, Void> storageAllocator = new ListObjectPool<IMutableValueStorage, Void>(ObjectFactories.STORAGE_FACTORY);
        private final IObjectPool<SortedRecord, ARecordType> recordPool = new ListObjectPool<SortedRecord, ARecordType>(ObjectFactories.RECORD_FACTORY);
        private final IAType type;
        private final int seed;

        private GenericHashFunction(IAType type, int seed) {
            this.type = type;
            this.seed = seed;
        }

        public int hash(byte[] bytes, int offset, int length) throws HyracksDataException {
            return this.hash(this.type, bytes, offset, length);
        }

        private int hash(IAType type, byte[] bytes, int offset, int length) throws HyracksDataException {
            this.valueBuffer.reset();
            ATypeTag sourceTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
            switch (sourceTag) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    try {
                        IntegerToDoubleTypeConvertComputer.getInstance().convertType(bytes, offset + 1, length - 1, this.valueOut);
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((ErrorCode)ErrorCode.NUMERIC_PROMOTION_ERROR, (Serializable[])new Serializable[]{e.getMessage()});
                    }
                    return MurmurHash3BinaryHash.hash((byte[])this.valueBuffer.getByteArray(), (int)this.valueBuffer.getStartOffset(), (int)this.valueBuffer.getLength(), (int)this.seed);
                }
                case FLOAT: {
                    try {
                        FloatToDoubleTypeConvertComputer.getInstance().convertType(bytes, offset + 1, length - 1, this.valueOut);
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((ErrorCode)ErrorCode.NUMERIC_PROMOTION_ERROR, (Serializable[])new Serializable[]{e.getMessage()});
                    }
                    return MurmurHash3BinaryHash.hash((byte[])this.valueBuffer.getByteArray(), (int)this.valueBuffer.getStartOffset(), (int)this.valueBuffer.getLength(), (int)this.seed);
                }
                case ARRAY: {
                    try {
                        return this.hashArray(type, bytes, offset);
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
                case OBJECT: {
                    return this.hashRecord(type, bytes, offset);
                }
            }
            return MurmurHash3BinaryHash.hash((byte[])bytes, (int)offset, (int)length, (int)this.seed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int hashArray(IAType type, byte[] bytes, int offset) throws IOException {
            IAType arrayType = TypeComputeUtils.getActualTypeOrOpen(type, ATypeTag.ARRAY);
            IAType itemType = ((AbstractCollectionType)arrayType).getItemType();
            ATypeTag itemTag = itemType.getTypeTag();
            int numItems = AOrderedListSerializerDeserializer.getNumberOfItems(bytes, offset);
            int hash = this.seed;
            IPointable item = this.voidPointableAllocator.allocate(null);
            ArrayBackedValueStorage storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
            try {
                for (int i = 0; i < numItems; ++i) {
                    ListAccessorUtil.getItem(bytes, offset, i, ATypeTag.ARRAY, itemTag, item, storage);
                    hash ^= this.hash(itemType, item.getByteArray(), item.getStartOffset(), item.getLength());
                }
            }
            finally {
                this.voidPointableAllocator.free(item);
                this.storageAllocator.free((IMutableValueStorage)storage);
            }
            return hash;
        }

        private int hashRecord(IAType type, byte[] bytes, int offset) throws HyracksDataException {
            ARecordType recordType = (ARecordType)TypeComputeUtils.getActualTypeOrOpen(type, ATypeTag.OBJECT);
            SortedRecord record = this.recordPool.allocate(recordType);
            IPointable fieldValue = this.voidPointableAllocator.allocate(null);
            ArrayBackedValueStorage storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
            try {
                record.reset(bytes, offset);
                int hash = this.seed;
                while (!record.isEmpty()) {
                    RecordField field = record.poll();
                    storage.reset();
                    record.getFieldValue(field, fieldValue, storage);
                    IAType fieldType = record.getFieldType(field);
                    hash ^= field.getName().hash() ^ this.hash(fieldType, fieldValue.getByteArray(), fieldValue.getStartOffset(), fieldValue.getLength());
                }
                int n = hash;
                return n;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            finally {
                this.recordPool.free(record);
                this.voidPointableAllocator.free(fieldValue);
                this.storageAllocator.free((IMutableValueStorage)storage);
            }
        }
    }
}

