/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.exceptions;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.ExceptionUtils;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String toExpectedTypeString(Object[] expectedItems) {
        StringBuilder expectedTypes = new StringBuilder();
        int numCandidateTypes = expectedItems.length;
        for (int index = 0; index < numCandidateTypes; ++index) {
            if (index > 0) {
                if (index == numCandidateTypes - 1) {
                    expectedTypes.append(" or ");
                } else {
                    expectedTypes.append(", ");
                }
            }
            expectedTypes.append(expectedItems[index]);
        }
        return expectedTypes.toString();
    }

    public static String toExpectedTypeString(byte[] expectedTypeTags) {
        StringBuilder expectedTypes = new StringBuilder();
        int numCandidateTypes = expectedTypeTags.length;
        for (int index = 0; index < numCandidateTypes; ++index) {
            if (index > 0) {
                if (index == numCandidateTypes - 1) {
                    expectedTypes.append(" or ");
                } else {
                    expectedTypes.append(", ");
                }
            }
            expectedTypes.append(EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(expectedTypeTags[index]));
        }
        return expectedTypes.toString();
    }

    public static String indexToPosition(int index) {
        int i = index + 1;
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        switch (i % 10) {
            case 1: {
                return i + "st";
            }
            case 2: {
                return i + "nd";
            }
            case 3: {
                return i + "rd";
            }
        }
        return i + "th";
    }

    public static void warnTypeMismatch(IEvaluatorContext ctx, SourceLocation srcLoc, FunctionIdentifier fid, byte actualType, int argIdx, ATypeTag expectedType) {
        ExceptionUtil.warnTypeMismatch(ctx, srcLoc, fid, actualType, argIdx, expectedType::toString);
    }

    public static void warnTypeMismatch(IEvaluatorContext ctx, SourceLocation srcLoc, FunctionIdentifier fid, byte actualType, int argIdx, byte[] expectedTypes) {
        ExceptionUtil.warnTypeMismatch(ctx, srcLoc, fid, actualType, argIdx, () -> ExceptionUtil.toExpectedTypeString(expectedTypes));
    }

    private static void warnTypeMismatch(IEvaluatorContext ctx, SourceLocation srcLoc, FunctionIdentifier fid, byte actualType, int argIdx, Supplier<String> expectedTypesString) {
        IWarningCollector warningCollector = ctx.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)srcLoc, (IError)org.apache.asterix.common.exceptions.ErrorCode.TYPE_MISMATCH_FUNCTION, (Serializable[])new Serializable[]{fid.getName(), ExceptionUtil.indexToPosition(argIdx), (Serializable)((Object)expectedTypesString.get()), EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(actualType)}));
        }
    }

    public static void warnIncompatibleType(IEvaluatorContext ctx, SourceLocation srcLoc, String funName, ATypeTag type1, ATypeTag type2) {
        IWarningCollector warningCollector = ctx.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)srcLoc, (IError)org.apache.asterix.common.exceptions.ErrorCode.TYPE_INCOMPATIBLE, (Serializable[])new Serializable[]{funName, type1, type2}));
        }
    }

    public static void warnUnsupportedType(IEvaluatorContext ctx, SourceLocation srcLoc, String funName, ATypeTag unsupportedType) {
        IWarningCollector warningCollector = ctx.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)srcLoc, (IError)org.apache.asterix.common.exceptions.ErrorCode.TYPE_UNSUPPORTED, (Serializable[])new Serializable[]{funName, unsupportedType}));
        }
    }

    public static void warnIncomparableTypes(IEvaluatorContext ctx, SourceLocation srcLoc, ATypeTag type1, ATypeTag type2) {
        IWarningCollector warningCollector = ctx.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)srcLoc, (IError)org.apache.asterix.common.exceptions.ErrorCode.INCOMPARABLE_TYPES, (Serializable[])new Serializable[]{type1, type2}));
        }
    }

    public static void warnNonInteger(IEvaluatorContext ctx, SourceLocation srcLoc, FunctionIdentifier fid, int argIdx, double argValue) {
        ExceptionUtil.warnInvalidValue(ctx, srcLoc, fid, argIdx, argValue, org.apache.asterix.common.exceptions.ErrorCode.INTEGER_VALUE_EXPECTED_FUNCTION);
    }

    public static void warnNegativeValue(IEvaluatorContext ctx, SourceLocation srcLoc, FunctionIdentifier fid, int argIdx, double argValue) {
        ExceptionUtil.warnInvalidValue(ctx, srcLoc, fid, argIdx, argValue, org.apache.asterix.common.exceptions.ErrorCode.NEGATIVE_VALUE);
    }

    public static void warnFunctionEvalFailed(IEvaluatorContext ctx, SourceLocation srcLoc, FunctionIdentifier fid, String errMsg) {
        if (ctx.getWarningCollector().shouldWarn()) {
            ctx.getWarningCollector().warn(Warning.of((SourceLocation)srcLoc, (IError)org.apache.asterix.common.exceptions.ErrorCode.FUNCTION_EVALUATION_FAILED, (Serializable[])new Serializable[]{fid.getName(), errMsg}));
        }
    }

    private static void warnInvalidValue(IEvaluatorContext ctx, SourceLocation srcLoc, FunctionIdentifier fid, int argIdx, double argValue, org.apache.asterix.common.exceptions.ErrorCode errorCode) {
        IWarningCollector warningCollector = ctx.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)srcLoc, (IError)errorCode, (Serializable[])new Serializable[]{fid.getName(), ExceptionUtil.indexToPosition(argIdx), Double.toString(argValue)}));
        }
    }

    public static boolean isStringUnicodeError(HyracksDataException throwable) {
        return ExceptionUtils.isErrorCode((HyracksDataException)throwable, (ErrorCode)ErrorCode.INVALID_STRING_UNICODE);
    }
}

