/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.List;
import java.util.PriorityQueue;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.tuples.TokenKeyPairTuple;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMInvertedIndexMergeCursor
extends EnforcedIndexCursor
implements ILSMIndexCursor {
    protected final LSMInvertedIndexOpContext opCtx;
    protected LSMIndexSearchCursor.PriorityQueueElement outputTokenElement;
    protected OnDiskInvertedIndexRangeSearchCursor[] rangeCursors;
    protected LSMIndexSearchCursor.PriorityQueueElement[] tokenQueueElements;
    protected PriorityQueue<LSMIndexSearchCursor.PriorityQueueElement> tokenQueue;
    protected LSMIndexSearchCursor.PriorityQueueComparator tokenQueueCmp;
    protected LSMIndexSearchCursor.PriorityQueueElement outputKeyElement;
    protected LSMIndexSearchCursor.PriorityQueueElement[] keyQueueElements;
    protected PriorityQueue<LSMIndexSearchCursor.PriorityQueueElement> keyQueue;
    protected LSMIndexSearchCursor.PriorityQueueComparator keyQueueCmp;
    protected boolean needPushElementIntoKeyQueue;
    protected ILSMHarness lsmHarness;
    protected MultiComparator tokenCmp;
    protected MultiComparator keyCmp;
    protected List<ILSMComponent> operationalComponents;
    protected IIndexCursor[] deletedKeysBTreeCursors;
    protected BloomFilter[] bloomFilters;
    protected final long[] hashes = BloomFilter.createHashArray();
    protected IIndexAccessor[] deletedKeysBTreeAccessors;
    protected RangePredicate deletedKeyBTreeSearchPred;
    protected final TokenKeyPairTuple outputTuple;
    protected final IIndexAccessParameters iap;

    public LSMInvertedIndexMergeCursor(ILSMIndexOperationContext opCtx, IIndexCursorStats stats) {
        this.opCtx = (LSMInvertedIndexOpContext)opCtx;
        this.outputTokenElement = null;
        this.outputKeyElement = null;
        this.needPushElementIntoKeyQueue = false;
        IInvertedIndex invertedIndex = (IInvertedIndex)this.opCtx.getIndex();
        this.outputTuple = new TokenKeyPairTuple(invertedIndex.getTokenTypeTraits().length, invertedIndex.getInvListTypeTraits().length);
        this.tokenCmp = MultiComparator.create((IBinaryComparatorFactory[])invertedIndex.getTokenCmpFactories());
        this.keyCmp = MultiComparator.create((IBinaryComparatorFactory[])invertedIndex.getInvListCmpFactories());
        this.tokenQueueCmp = new LSMIndexSearchCursor.PriorityQueueComparator(this.tokenCmp);
        this.keyQueueCmp = new LSMIndexSearchCursor.PriorityQueueComparator(this.keyCmp);
        this.iap = IndexAccessParameters.createNoOpParams((IIndexCursorStats)stats);
    }

    public LSMInvertedIndexOpContext getOpCtx() {
        return this.opCtx;
    }

    public void doOpen(ICursorInitialState initState, ISearchPredicate searchPred) throws HyracksDataException {
        int i;
        LSMInvertedIndexRangeSearchCursorInitialState lsmInitState = (LSMInvertedIndexRangeSearchCursorInitialState)initState;
        List<ILSMComponent> components = lsmInitState.getOperationalComponents();
        int numComponents = lsmInitState.getNumComponents();
        this.rangeCursors = new OnDiskInvertedIndexRangeSearchCursor[numComponents];
        for (i = 0; i < numComponents; ++i) {
            IInvertedIndexAccessor invIndexAccessor = (IInvertedIndexAccessor)components.get(i).getIndex().createAccessor(this.iap);
            this.rangeCursors[i] = (OnDiskInvertedIndexRangeSearchCursor)invIndexAccessor.createRangeSearchCursor();
            invIndexAccessor.rangeSearch((IIndexCursor)this.rangeCursors[i], lsmInitState.getSearchPredicate());
        }
        this.lsmHarness = lsmInitState.getLSMHarness();
        this.operationalComponents = lsmInitState.getOperationalComponents();
        this.deletedKeysBTreeAccessors = new IIndexAccessor[numComponents];
        this.bloomFilters = new BloomFilter[numComponents];
        this.deletedKeysBTreeCursors = new IIndexCursor[numComponents];
        for (i = 0; i < numComponents; ++i) {
            ILSMComponent component = this.operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.deletedKeysBTreeAccessors[i] = ((LSMInvertedIndexMemoryComponent)component).getBuddyIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                this.bloomFilters[i] = null;
            } else {
                this.deletedKeysBTreeAccessors[i] = ((LSMInvertedIndexDiskComponent)component).getBuddyIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                this.bloomFilters[i] = ((LSMInvertedIndexDiskComponent)component).getBloomFilter();
            }
            this.deletedKeysBTreeCursors[i] = this.deletedKeysBTreeAccessors[i].createSearchCursor(false);
        }
        this.deletedKeyBTreeSearchPred = new RangePredicate(null, null, true, true, this.keyCmp, this.keyCmp);
        this.initPriorityQueues();
    }

    private void initPriorityQueues() throws HyracksDataException {
        int i;
        int pqInitSize = this.rangeCursors.length > 0 ? this.rangeCursors.length : 1;
        this.tokenQueue = new PriorityQueue(pqInitSize, this.tokenQueueCmp);
        this.keyQueue = new PriorityQueue(pqInitSize, this.keyQueueCmp);
        this.tokenQueueElements = new LSMIndexSearchCursor.PriorityQueueElement[pqInitSize];
        this.keyQueueElements = new LSMIndexSearchCursor.PriorityQueueElement[pqInitSize];
        for (i = 0; i < pqInitSize; ++i) {
            this.tokenQueueElements[i] = new LSMIndexSearchCursor.PriorityQueueElement(i);
            this.keyQueueElements[i] = new LSMIndexSearchCursor.PriorityQueueElement(i);
        }
        for (i = 0; i < this.rangeCursors.length; ++i) {
            if (this.rangeCursors[i].hasNext()) {
                this.rangeCursors[i].next();
                this.tokenQueueElements[i].reset(this.rangeCursors[i].getTuple());
                this.tokenQueue.offer(this.tokenQueueElements[i]);
                continue;
            }
            this.rangeCursors[i].close();
        }
        this.searchNextToken();
    }

    private void searchNextToken() throws HyracksDataException {
        LSMIndexSearchCursor.PriorityQueueElement tokenElement;
        if (this.tokenQueue.isEmpty()) {
            return;
        }
        if (!this.keyQueue.isEmpty()) {
            throw new IllegalStateException("Illegal call of initializing key queue");
        }
        this.outputTokenElement = this.tokenQueue.poll();
        this.initPushIntoKeyQueue(this.outputTokenElement);
        ITupleReference tokenTuple = this.getTokenTuple(this.outputTokenElement);
        this.outputTuple.setTokenTuple(tokenTuple);
        while (!this.tokenQueue.isEmpty() && TupleUtils.equalTuples((ITupleReference)tokenTuple, (ITupleReference)this.getTokenTuple(tokenElement = this.tokenQueue.peek()), (int)this.tokenCmp.getKeyFieldCount())) {
            this.initPushIntoKeyQueue(tokenElement);
            this.tokenQueue.poll();
        }
    }

    private ITupleReference getKeyTuple(LSMIndexSearchCursor.PriorityQueueElement tokenElement) {
        return ((TokenKeyPairTuple)tokenElement.getTuple()).getKeyTuple();
    }

    private ITupleReference getTokenTuple(LSMIndexSearchCursor.PriorityQueueElement tokenElement) {
        return ((TokenKeyPairTuple)tokenElement.getTuple()).getTokenTuple();
    }

    private void initPushIntoKeyQueue(LSMIndexSearchCursor.PriorityQueueElement tokenElement) {
        LSMIndexSearchCursor.PriorityQueueElement keyElement = this.keyQueueElements[tokenElement.getCursorIndex()];
        keyElement.reset(this.getKeyTuple(tokenElement));
        this.keyQueue.add(keyElement);
    }

    private void pushIntoKeyQueueAndReplace(LSMIndexSearchCursor.PriorityQueueElement keyElement) throws HyracksDataException {
        int cursorIndex = keyElement.getCursorIndex();
        if (this.rangeCursors[cursorIndex].hasNext()) {
            this.rangeCursors[cursorIndex].next();
            TokenKeyPairTuple tuple = (TokenKeyPairTuple)this.rangeCursors[cursorIndex].getTuple();
            if (tuple.isNewToken()) {
                LSMIndexSearchCursor.PriorityQueueElement tokenElement = this.tokenQueueElements[cursorIndex];
                tokenElement.reset((ITupleReference)tuple);
                this.tokenQueue.offer(tokenElement);
            } else {
                keyElement.reset(tuple.getKeyTuple());
                this.keyQueue.offer(keyElement);
            }
        } else {
            this.rangeCursors[cursorIndex].close();
        }
    }

    public boolean doHasNext() throws HyracksDataException {
        this.checkPriorityQueue();
        return !this.keyQueue.isEmpty();
    }

    public void doNext() throws HyracksDataException {
        this.outputKeyElement = this.keyQueue.poll();
        this.outputTuple.setKeyTuple(this.outputKeyElement.getTuple());
        this.needPushElementIntoKeyQueue = true;
    }

    public ITupleReference doGetTuple() {
        return this.outputTuple;
    }

    protected void checkPriorityQueue() throws HyracksDataException {
        this.checkKeyQueue();
        if (this.keyQueue.isEmpty()) {
            this.searchNextToken();
            this.checkKeyQueue();
        }
    }

    protected void checkKeyQueue() throws HyracksDataException {
        while (!this.keyQueue.isEmpty() || this.needPushElementIntoKeyQueue) {
            if (!this.keyQueue.isEmpty()) {
                LSMIndexSearchCursor.PriorityQueueElement checkElement = this.keyQueue.peek();
                if (this.outputKeyElement == null) {
                    if (this.isDeleted(checkElement)) {
                        this.outputKeyElement = checkElement;
                        this.needPushElementIntoKeyQueue = true;
                        continue;
                    }
                    return;
                }
                if (this.keyCmp.compare(this.outputKeyElement.getTuple(), checkElement.getTuple()) == 0) {
                    LSMIndexSearchCursor.PriorityQueueElement e = this.keyQueue.poll();
                    this.pushIntoKeyQueueAndReplace(e);
                    continue;
                }
                if (this.needPushElementIntoKeyQueue) {
                    this.pushIntoKeyQueueAndReplace(this.outputKeyElement);
                    this.needPushElementIntoKeyQueue = false;
                }
                this.outputKeyElement = null;
                continue;
            }
            this.pushIntoKeyQueueAndReplace(this.outputKeyElement);
            this.needPushElementIntoKeyQueue = false;
            this.outputKeyElement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement keyElement) throws HyracksDataException {
        ITupleReference keyTuple = keyElement.getTuple();
        int end = keyElement.getCursorIndex();
        for (int i = 0; i < end; ++i) {
            if (this.bloomFilters[i] != null && !this.bloomFilters[i].contains(keyTuple, this.hashes)) continue;
            this.deletedKeysBTreeCursors[i].close();
            this.deletedKeysBTreeAccessors[i].search(this.deletedKeysBTreeCursors[i], (ISearchPredicate)this.deletedKeyBTreeSearchPred);
            try {
                if (!this.deletedKeysBTreeCursors[i].hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                this.deletedKeysBTreeCursors[i].close();
            }
        }
        return false;
    }

    public void doClose() throws HyracksDataException {
        this.outputTokenElement = null;
        this.outputKeyElement = null;
        this.needPushElementIntoKeyQueue = false;
        try {
            if (this.rangeCursors != null) {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.rangeCursors[i].close();
                }
            }
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch((ILSMIndexOperationContext)this.opCtx);
            }
        }
    }

    public void doDestroy() throws HyracksDataException {
        try {
            if (this.tokenQueue != null) {
                this.tokenQueue.clear();
            }
            if (this.keyQueue != null) {
                this.keyQueue.clear();
            }
            if (this.rangeCursors != null) {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    if (this.rangeCursors[i] == null) continue;
                    this.rangeCursors[i].destroy();
                }
                this.rangeCursors = null;
            }
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch((ILSMIndexOperationContext)this.opCtx);
            }
        }
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return false;
    }
}

