/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.HandleState;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.Message;

final class IPCHandle
implements IIPCHandle {
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final IPCSystem system;
    private InetSocketAddress remoteAddress;
    private HandleState state;
    private SelectionKey key;
    private Object attachment;
    private int attachmentLen;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private boolean full;
    private ISocketChannel socketChannel;

    IPCHandle(IPCSystem system, InetSocketAddress remoteAddress) {
        this.system = system;
        this.remoteAddress = remoteAddress;
        this.inBuffer = ByteBuffer.allocate(0x100000);
        this.outBuffer = ByteBuffer.allocate(0x100000);
        this.outBuffer.flip();
        this.state = HandleState.INITIAL;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    IPCSystem getIPCSystem() {
        return this.system;
    }

    @Override
    public long send(long requestId, Object req, Exception exception) throws IPCException {
        if (!this.isConnected()) {
            throw new IPCException("Handle is not in Connected state");
        }
        Message msg = new Message(this);
        long mid = this.system.createMessageId();
        msg.setMessageId(mid);
        msg.setRequestMessageId(requestId);
        if (exception != null) {
            msg.setFlag((byte)3);
            msg.setPayload(exception);
        } else {
            msg.setFlag((byte)0);
            msg.setPayload(req);
        }
        this.system.getConnectionManager().send(msg);
        return mid;
    }

    @Override
    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public int getAttachmentLen() {
        return this.attachmentLen;
    }

    SelectionKey getKey() {
        return this.key;
    }

    void setKey(SelectionKey key) {
        this.key = key;
    }

    public ISocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(ISocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.state == HandleState.CONNECTED;
    }

    synchronized HandleState getState() {
        return this.state;
    }

    synchronized void setState(HandleState state) {
        this.state = state;
        this.notifyAll();
    }

    synchronized boolean waitTillConnected() throws InterruptedException {
        block4: while (true) {
            switch (this.state) {
                case INITIAL: 
                case CONNECT_SENT: 
                case CONNECT_RECEIVED: {
                    this.wait();
                    continue block4;
                }
                case CONNECTED: 
                case CLOSED: {
                    return this.state == HandleState.CONNECTED;
                }
            }
            break;
        }
        throw new IllegalStateException("unknown state: " + this.state);
    }

    ByteBuffer getInBuffer() {
        return this.inBuffer;
    }

    ByteBuffer getOutBuffer() {
        return this.outBuffer;
    }

    synchronized void close() {
        this.setState(HandleState.CLOSED);
    }

    void processIncomingMessages() {
        this.inBuffer.flip();
        while (Message.hasMessage(this.inBuffer)) {
            boolean error;
            Message message = new Message(this);
            try {
                message.read(this.inBuffer);
            }
            catch (Exception e) {
                message.setFlag((byte)3);
                message.setPayload(e);
            }
            this.system.getPerformanceCounters().addMessageReceivedCount(1L);
            boolean bl = error = message.getFlag() == 3;
            if (!error && this.state == HandleState.CONNECT_RECEIVED) {
                this.remoteAddress = (InetSocketAddress)message.getPayload();
                this.setState(HandleState.CONNECTED);
                this.system.getConnectionManager().ack(this, message);
                continue;
            }
            if (!error && this.state == HandleState.CONNECT_SENT) {
                if (message.getFlag() == 2) {
                    this.setState(HandleState.CONNECTED);
                    continue;
                }
                throw new IllegalStateException();
            }
            this.attachmentLen = message.getPayloadLen();
            this.system.deliverIncomingMessage(message);
        }
        this.inBuffer.compact();
    }

    void resizeInBuffer() {
        this.inBuffer.flip();
        ByteBuffer readBuffer = ByteBuffer.allocate(this.inBuffer.capacity() * 2);
        readBuffer.put(this.inBuffer);
        this.inBuffer = readBuffer;
    }

    void resizeOutBuffer() {
        ByteBuffer writeBuffer = ByteBuffer.allocate(this.outBuffer.capacity() * 2);
        writeBuffer.put(this.outBuffer);
        writeBuffer.flip();
        this.outBuffer = writeBuffer;
    }

    void markFull() {
        this.full = true;
    }

    void clearFull() {
        this.full = false;
    }

    boolean full() {
        return this.full;
    }

    public String toString() {
        return "IPCHandle [addr=" + this.remoteAddress + " state=" + this.state + "]";
    }
}

