/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AUUID;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class AMutableUUID
extends AUUID {
    private final byte[] hexBytesBuffer = new byte[36];

    public void parseUUIDString(char[] buffer, int begin, int len) throws HyracksDataException {
        if (len != 36) {
            throw new HyracksDataException("This is not a correct UUID value: " + new String(buffer, begin, len));
        }
        for (int i = 0; i < len; ++i) {
            this.hexBytesBuffer[i] = (byte)buffer[begin + i];
        }
        this.parseUUIDHexBytes(this.hexBytesBuffer, 0);
    }

    public void parseUUIDHexBytes(byte[] serString, int offset) throws HyracksDataException {
        AMutableUUID.decodeBytesFromHex(serString, offset, this.uuidBytes, 0, 8);
        offset += 8;
        AMutableUUID.decodeBytesFromHex(serString, ++offset, this.uuidBytes, 4, 4);
        offset += 4;
        AMutableUUID.decodeBytesFromHex(serString, ++offset, this.uuidBytes, 6, 4);
        offset += 4;
        AMutableUUID.decodeBytesFromHex(serString, ++offset, this.uuidBytes, 8, 4);
        offset += 4;
        AMutableUUID.decodeBytesFromHex(serString, ++offset, this.uuidBytes, 10, 12);
    }

    private static void decodeBytesFromHex(byte[] hexArray, int hexArrayOffset, byte[] outputArray, int outputOffset, int length) throws HyracksDataException {
        try {
            int i = hexArrayOffset;
            while (i < hexArrayOffset + length) {
                int hi = AMutableUUID.transformHexCharToInt(hexArray[i++]);
                outputArray[outputOffset++] = (byte)(hi << 4 | AMutableUUID.transformHexCharToInt(hexArray[i++]));
            }
        }
        catch (Exception ex) {
            throw new RuntimeDataException(ErrorCode.INVALID_FORMAT, new Serializable[]{"uuid", UTF8StringUtil.toString((byte[])hexArray, (int)1)});
        }
    }

    private static int transformHexCharToInt(byte val) throws HyracksDataException {
        switch (val) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new RuntimeDataException(ErrorCode.INVALID_FORMAT, new Serializable[0]);
    }
}

