/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.filter.iterable.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.column.filter.iterable.evaluator.AbstractIterableFilterEvaluator;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ColumnarRepeatedIterableFilterEvaluator
extends AbstractIterableFilterEvaluator {
    private final List<IColumnValuesReader> readers;
    private final List<IColumnValuesReader> repeatedReaders;

    ColumnarRepeatedIterableFilterEvaluator(IScalarEvaluator evaluator, List<IColumnValuesReader> readers) {
        super(evaluator);
        this.readers = readers;
        this.repeatedReaders = new ArrayList<IColumnValuesReader>();
        for (IColumnValuesReader reader : readers) {
            if (!reader.isRepeated()) continue;
            this.repeatedReaders.add(reader);
        }
    }

    @Override
    public boolean evaluate() throws HyracksDataException {
        boolean result = false;
        while (!result && this.next()) {
            result = this.evaluateRepeated();
            ++this.index;
        }
        if (!result) {
            ++this.index;
        }
        return result;
    }

    private boolean evaluateRepeated() throws HyracksDataException {
        boolean doNext;
        boolean result = false;
        do {
            doNext = false;
            result |= this.inspect();
            for (int i = 0; i < this.repeatedReaders.size(); ++i) {
                IColumnValuesReader reader = this.repeatedReaders.get(i);
                boolean repeatedValue = reader.isRepeatedValue() && !reader.isLastDelimiter();
                doNext |= repeatedValue;
                if (!repeatedValue) continue;
                reader.next();
            }
        } while (doNext);
        return result;
    }

    private boolean next() throws HyracksDataException {
        for (int i = 0; i < this.readers.size(); ++i) {
            if (this.readers.get(i).next()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void skip(int count) throws HyracksDataException {
        for (int i = 0; count > 0 && i < this.readers.size(); ++i) {
            this.readers.get(i).skip(count);
        }
    }
}

