/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader.value;

import java.io.IOException;
import org.apache.asterix.column.bytes.decoder.ParquetRunLengthBitPackingHybridDecoder;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class BooleanValueReader
extends AbstractValueReader {
    private final ParquetRunLengthBitPackingHybridDecoder booleanReader = new ParquetRunLengthBitPackingHybridDecoder(1);
    private boolean nextValue;

    @Override
    public void init(AbstractBytesInputStream in, int tupleCount) {
        this.booleanReader.reset(in);
    }

    @Override
    public void nextValue() throws HyracksDataException {
        try {
            this.nextValue = this.booleanReader.readInt() == 1;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public boolean getBoolean() {
        return this.nextValue;
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.BOOLEAN;
    }

    @Override
    public int compareTo(AbstractValueReader o) {
        return Boolean.compare(this.nextValue, o.getBoolean());
    }
}

