/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FramePoolBackedFrameBufferManager;
import org.apache.hyracks.dataflow.std.join.InMemoryHashJoin;
import org.apache.hyracks.dataflow.std.structures.SerializableHashTable;

public class InMemoryHashJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int[] keys0;
    private final int[] keys1;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories0;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories1;
    private final ITuplePairComparatorFactory comparatorFactory;
    private final boolean isLeftOuter;
    private final IMissingWriterFactory[] nonMatchWriterFactories;
    private final int tableSize;
    private final int memSizeInFrames;

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories0, IBinaryHashFunctionFactory[] hashFunctionFactories1, ITuplePairComparatorFactory comparatorFactory, RecordDescriptor recordDescriptor, int tableSize, int memSizeInFrames) {
        this(spec, keys0, keys1, hashFunctionFactories0, hashFunctionFactories1, comparatorFactory, recordDescriptor, false, null, tableSize, memSizeInFrames);
    }

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories0, IBinaryHashFunctionFactory[] hashFunctionFactories1, ITuplePairComparatorFactory comparatorFactory, RecordDescriptor recordDescriptor, boolean isLeftOuter, IMissingWriterFactory[] missingWriterFactories1, int tableSize, int memSizeInFrames) {
        super(spec, 2, 1);
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories0 = hashFunctionFactories0;
        this.hashFunctionFactories1 = hashFunctionFactories1;
        this.comparatorFactory = comparatorFactory;
        this.outRecDescs[0] = recordDescriptor;
        this.isLeftOuter = isLeftOuter;
        this.nonMatchWriterFactories = missingWriterFactories1;
        this.tableSize = tableSize;
        this.memSizeInFrames = memSizeInFrames;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId hbaId = new ActivityId(this.odId, 0);
        ActivityId hpaId = new ActivityId(this.odId, 1);
        HashBuildActivityNode hba = new HashBuildActivityNode(hbaId, hpaId);
        HashProbeActivityNode hpa = new HashProbeActivityNode(hpaId);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)hba);
        builder.addSourceEdge(1, (IActivity)hba, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)hpa);
        builder.addSourceEdge(0, (IActivity)hpa, 0);
        builder.addTargetEdge(0, (IActivity)hpa, 0);
        builder.addBlockingEdge((IActivity)hba, (IActivity)hpa);
    }

    private class HashBuildActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId hpaId;

        public HashBuildActivityNode(ActivityId id, ActivityId hpaId) {
            super(id);
            this.hpaId = hpaId;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
            IMissingWriter[] nullWriters1;
            final IHyracksJobletContext jobletCtx = ctx.getJobletContext();
            final RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.hpaId, 0);
            final RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            if (InMemoryHashJoinOperatorDescriptor.this.isLeftOuter) {
                nullWriters1 = new IMissingWriter[InMemoryHashJoinOperatorDescriptor.this.nonMatchWriterFactories.length];
                for (int i = 0; i < InMemoryHashJoinOperatorDescriptor.this.nonMatchWriterFactories.length; ++i) {
                    nullWriters1[i] = InMemoryHashJoinOperatorDescriptor.this.nonMatchWriterFactories[i].createMissingWriter();
                }
            } else {
                nullWriters1 = null;
            }
            int memSizeInBytes = InMemoryHashJoinOperatorDescriptor.this.memSizeInFrames * jobletCtx.getInitialFrameSize();
            DeallocatableFramePool framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)jobletCtx, memSizeInBytes);
            final FramePoolBackedFrameBufferManager bufferManager = new FramePoolBackedFrameBufferManager(framePool);
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private HashBuildTaskState state;

                public void open() throws HyracksDataException {
                    ITuplePartitionComputer hpc0 = FieldHashPartitionComputerFactory.of((int[])InMemoryHashJoinOperatorDescriptor.this.keys0, (IBinaryHashFunctionFactory[])InMemoryHashJoinOperatorDescriptor.this.hashFunctionFactories0).createPartitioner(ctx);
                    ITuplePartitionComputer hpc1 = FieldHashPartitionComputerFactory.of((int[])InMemoryHashJoinOperatorDescriptor.this.keys1, (IBinaryHashFunctionFactory[])InMemoryHashJoinOperatorDescriptor.this.hashFunctionFactories1).createPartitioner(ctx);
                    this.state = new HashBuildTaskState(jobletCtx.getJobId(), new TaskId(HashBuildActivityNode.this.getActivityId(), partition));
                    SerializableHashTable table = new SerializableHashTable(InMemoryHashJoinOperatorDescriptor.this.tableSize, (IHyracksFrameMgrContext)jobletCtx, bufferManager);
                    this.state.joiner = new InMemoryHashJoin((IHyracksFrameMgrContext)jobletCtx, new FrameTupleAccessor(rd0), hpc0, new FrameTupleAccessor(rd1), rd1, hpc1, InMemoryHashJoinOperatorDescriptor.this.isLeftOuter, nullWriters1, table, bufferManager);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    ByteBuffer copyBuffer = this.allocateBuffer(buffer.capacity());
                    FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)copyBuffer);
                    this.state.joiner.build(copyBuffer);
                }

                private ByteBuffer allocateBuffer(int frameSize) throws HyracksDataException {
                    ByteBuffer newBuffer = bufferManager.acquireFrame(frameSize);
                    if (newBuffer != null) {
                        return newBuffer;
                    }
                    if (this.state.joiner.compactHashTable() > 0 && (newBuffer = bufferManager.acquireFrame(frameSize)) != null) {
                        return newBuffer;
                    }
                    throw new HyracksDataException("Can't allocate one more frame. Assign more memory to InMemoryHashJoin.");
                }

                public void close() throws HyracksDataException {
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
            return op;
        }
    }

    private class HashProbeActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public HashProbeActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputUnaryOutputOperatorNodePushable op = new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private HashBuildTaskState state;

                public void open() throws HyracksDataException {
                    this.writer.open();
                    this.state = (HashBuildTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(InMemoryHashJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                    this.state.joiner.setComparator(InMemoryHashJoinOperatorDescriptor.this.comparatorFactory.createTuplePairComparator(ctx));
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.joiner.join(buffer, this.writer);
                }

                public void close() throws HyracksDataException {
                    try {
                        this.state.joiner.completeJoin(this.writer);
                    }
                    finally {
                        try {
                            this.state.joiner.releaseMemory();
                        }
                        finally {
                            this.writer.close();
                        }
                    }
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }
            };
            return op;
        }
    }

    static class HashBuildTaskState
    extends AbstractStateObject {
        InMemoryHashJoin joiner;

        private HashBuildTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        @Override
        public void toBytes(DataOutput out) throws IOException {
        }

        @Override
        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

