/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.IFieldValue;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.ObjectConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.RepeatedConverter;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;

public abstract class AbstractComplexConverter
extends GroupConverter
implements IFieldValue {
    protected final AbstractComplexConverter parent;
    private final IValueReference fieldName;
    private final String stringFieldName;
    private final int index;
    private final Converter[] converters;
    protected final ParquetConverterContext context;
    protected IMutableValueStorage tempStorage;

    AbstractComplexConverter(AbstractComplexConverter parent, int index, GroupType parquetType, ParquetConverterContext context) throws IOException {
        this(parent, null, index, parquetType, context);
    }

    AbstractComplexConverter(AbstractComplexConverter parent, String stringFieldName, int index, GroupType parquetType, ParquetConverterContext context) throws IOException {
        this.parent = parent;
        this.stringFieldName = stringFieldName;
        this.fieldName = context.getSerializedFieldName(stringFieldName);
        this.index = index;
        this.context = context;
        this.converters = new Converter[parquetType.getFieldCount()];
        for (int i = 0; i < parquetType.getFieldCount(); ++i) {
            Type type = parquetType.getType(i);
            this.converters[i] = type.isPrimitive() ? this.createAtomicConverter(parquetType, i) : (LogicalTypeAnnotation.listType().equals((Object)type.getLogicalTypeAnnotation()) ? this.createArrayConverter(parquetType, i) : (type.getRepetition() == Type.Repetition.REPEATED ? this.createRepeatedConverter(parquetType, i) : (type.getLogicalTypeAnnotation() == LogicalTypeAnnotation.mapType() ? this.createArrayConverter(parquetType, i) : this.createObjectConverter(parquetType, i))));
        }
    }

    public abstract void addValue(IFieldValue var1);

    protected abstract PrimitiveConverter createAtomicConverter(GroupType var1, int var2);

    protected abstract AbstractComplexConverter createArrayConverter(GroupType var1, int var2);

    protected abstract AbstractComplexConverter createObjectConverter(GroupType var1, int var2);

    protected AbstractComplexConverter createRepeatedConverter(GroupType type, int index) throws IOException {
        GroupType repeatedType = type.getType(index).asGroupType();
        String name = repeatedType.getName();
        if (repeatedType.getFieldCount() > 1 || "array".equals(name) || "key_value".equals(name)) {
            return new ObjectConverter(this, index, repeatedType, this.context);
        }
        return new RepeatedConverter(this, index, repeatedType, this.context);
    }

    @Override
    public String getStringFieldName() {
        return this.stringFieldName;
    }

    @Override
    public IValueReference getFieldName() {
        return this.fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public DataOutput getDataOutput() {
        this.tempStorage.reset();
        return this.tempStorage.getDataOutput();
    }

    public IMutableValueStorage getValue() {
        return this.tempStorage;
    }

    protected DataOutput getParentDataOutput() {
        return this.parent.getDataOutput();
    }

    protected void addThisValueToParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.addValue(this);
    }
}

