/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xpointer;

import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.woden.XMLElement;
import org.apache.woden.types.NCName;
import org.apache.woden.xpointer.ElementPointerPart;
import org.apache.woden.xpointer.PointerPart;
import org.apache.woden.xpointer.XPointer;

public abstract class XMLElementEvaluator {
    private final XPointer xpointer;
    private final XMLElement root;

    public XMLElementEvaluator(XPointer xpointer, XMLElement root) {
        this.xpointer = xpointer;
        this.root = root;
    }

    public XMLElement evaluate() {
        if (this.xpointer.hasPointerParts()) {
            XMLElement result = null;
            for (PointerPart pointerPart : Arrays.asList(this.xpointer.getPointerParts())) {
                if (pointerPart instanceof ElementPointerPart) {
                    result = this.evaluateElementPointerPart((ElementPointerPart)pointerPart);
                }
                if (result == null) continue;
                return result;
            }
        } else if (this.xpointer.hasShorthandPointer()) {
            return this.evaluateShorthandPointer(this.xpointer.getShorthandPointer());
        }
        return null;
    }

    private XMLElement evaluateElementPointerPart(ElementPointerPart elementPointerPart) {
        if (elementPointerPart.hasChildSequence() && elementPointerPart.hasNCName()) {
            XMLElement element = this.evaluateShorthandPointer(elementPointerPart.getNCName());
            if (element == null) {
                return null;
            }
            return this.evaluateChildSequence(element, elementPointerPart.getChildSequence());
        }
        if (elementPointerPart.hasNCName()) {
            return this.evaluateShorthandPointer(elementPointerPart.getNCName());
        }
        Integer[] childSequence = elementPointerPart.getChildSequence();
        if (childSequence[0] > 1) {
            return null;
        }
        Integer[] nChildSequence = new Integer[childSequence.length - 1];
        for (int i = 1; i < childSequence.length; ++i) {
            nChildSequence[i - 1] = childSequence[i];
        }
        return this.evaluateChildSequence(this.root, nChildSequence);
    }

    private XMLElement evaluateShorthandPointer(NCName ncname) {
        String shorthand = ncname.toString();
        DocumentOrderIterator it = new DocumentOrderIterator(this.root);
        while (it.hasNext()) {
            XMLElement element = (XMLElement)it.next();
            if (!this.testElementShorthand(element, shorthand)) continue;
            return element;
        }
        return null;
    }

    private XMLElement evaluateChildSequence(XMLElement element, Integer[] childSequence) {
        for (int i = 0; i < childSequence.length; ++i) {
            XMLElement[] children = element.getChildElements();
            children = XMLElementEvaluator.filterNoneElementNodes(children);
            if (childSequence[i] > children.length) {
                return null;
            }
            element = element.getChildElements()[childSequence[i] - 1];
        }
        return element;
    }

    private static XMLElement[] filterNoneElementNodes(XMLElement[] nodes) {
        List<XMLElement> nodeList = Arrays.asList(nodes);
        Iterator<XMLElement> it = nodeList.iterator();
        while (it.hasNext()) {
            XMLElement node = it.next();
            if (node.getLocalName().indexOf(35) <= -1) continue;
            it.remove();
        }
        XMLElement[] nNodes = new XMLElement[nodeList.size()];
        nodeList.toArray(nNodes);
        return nNodes;
    }

    public abstract boolean testElementShorthand(XMLElement var1, String var2);

    private class DocumentOrderIterator
    implements Iterator {
        private final Stack stack = new Stack();

        public DocumentOrderIterator(XMLElement root) {
            this.stack.add(root);
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public Object next() {
            XMLElement element;
            try {
                element = (XMLElement)this.stack.pop();
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException();
            }
            List<XMLElement> children = Arrays.asList(element.getChildElements());
            Collections.reverse(children);
            this.stack.addAll(children);
            return element;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

