/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.classfile.Utility;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.runtime.JiBXException;

public abstract class StringConversion {
    protected static final String UNMARSHAL_OPT_ATTRIBUTE = "org.jibx.runtime.impl.UnmarshallingContext.attributeText";
    protected static final String UNMARSHAL_OPT_ELEMENT = "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
    protected static final String UNMARSHAL_OPT_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
    protected static final String UNMARSHAL_REQ_ATTRIBUTE = "org.jibx.runtime.impl.UnmarshallingContext.attributeText";
    protected static final String UNMARSHAL_REQ_ELEMENT = "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
    protected static final String UNMARSHAL_REQ_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
    protected static final String MARSHAL_ATTRIBUTE = "org.jibx.runtime.impl.MarshallingContext.attribute";
    protected static final String MARSHAL_ELEMENT = "org.jibx.runtime.impl.MarshallingContext.element";
    protected static final String MARSHAL_SIGNATURE = "(ILjava/lang/String;Ljava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;";
    protected static final String COMPARE_OBJECTS_METHOD = "org.jibx.runtime.Utility.isEqual";
    protected static final String COMPARE_OBJECTS_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;)Z";
    protected static final String[] WHITESPACE_CONVERT_SIGNATURES = new String[]{"(Ljava/lang/String;)Ljava/lang/String;"};
    protected static final String[] DESERIALIZER_SIGNATURES = new String[]{"(Ljava/lang/String;)", "(Ljava/lang/String;Lorg/jibx/runtime/IUnmarshallingContext;)"};
    public static final int MARSHAL_NAME_VALUES = 2;
    protected Object m_default;
    protected ClassItem m_serializer;
    protected ClassItem m_converter;
    protected ClassItem m_deserializer;
    protected String m_typeName;
    protected String m_typeSignature;

    private StringConversion(String type) {
        this.m_typeName = type;
        this.m_typeSignature = Utility.getSignature((String)type);
    }

    protected StringConversion(String type, StringConversion inherit) {
        this(type);
        this.m_default = inherit.m_default;
        this.m_serializer = inherit.m_serializer;
        this.m_converter = inherit.m_converter;
        this.m_deserializer = inherit.m_deserializer;
    }

    StringConversion(Object dflt, String ser, String conv, String deser, String type) {
        this(type);
        this.m_default = dflt;
        try {
            if (ser != null) {
                this.setSerializer(ser, false);
            }
            if (conv != null) {
                this.setWhitespaceConverter(conv);
            }
            if (deser != null) {
                this.setDeserializer(deser);
            }
        }
        catch (JiBXException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public abstract void genFromText(ContextMethodBuilder var1) throws JiBXException;

    public abstract void genParseOptional(boolean var1, ContextMethodBuilder var2) throws JiBXException;

    public abstract void genParseRequired(boolean var1, ContextMethodBuilder var2) throws JiBXException;

    public void genWriteText(boolean attr, ContextMethodBuilder mb) {
        String name = attr ? MARSHAL_ATTRIBUTE : MARSHAL_ELEMENT;
        mb.appendCallVirtual(name, MARSHAL_SIGNATURE);
    }

    public void genPopValues(int count, ContextMethodBuilder mb) {
        while (--count >= 0) {
            if (mb.isStackTopLong()) {
                mb.appendPOP2();
                continue;
            }
            mb.appendPOP();
        }
    }

    protected abstract BranchWrapper genToOptionalText(String var1, ContextMethodBuilder var2, int var3) throws JiBXException;

    public void genToText(String type, ContextMethodBuilder mb) throws JiBXException {
        if (this.m_serializer != null) {
            if (!this.isPrimitive()) {
                mb.appendCreateCast(type, this.m_serializer.getArgumentType(0));
            }
            mb.addMethodExceptions(this.m_serializer);
            if (this.m_serializer.getArgumentCount() > 1) {
                mb.loadContext();
            }
            mb.appendCall(this.m_serializer);
        } else {
            mb.appendCreateCast(type, "java.lang.String");
        }
    }

    public void genWriteOptional(boolean attr, String type, ContextMethodBuilder mb) throws JiBXException {
        BranchWrapper toend = this.genToOptionalText(type, mb, 2);
        this.genWriteText(attr, mb);
        if (toend != null) {
            mb.targetNext(toend);
        }
    }

    public void genWriteRequired(boolean attr, String type, ContextMethodBuilder mb) throws JiBXException {
        this.genToText(type, mb);
        this.genWriteText(attr, mb);
    }

    public abstract boolean isPrimitive();

    protected void setSerializer(String ser, boolean variant) throws JiBXException {
        String[] tsigs = variant ? ClassItem.getSignatureVariants(this.m_typeName) : new String[]{Utility.getSignature((String)this.m_typeName)};
        String[] msigs = new String[tsigs.length * 2];
        for (int i = 0; i < tsigs.length; ++i) {
            msigs[i * 2] = "(" + tsigs[i] + ")Ljava/lang/String;";
            msigs[i * 2 + 1] = "(" + tsigs[i] + "Lorg/jibx/runtime/IMarshallingContext;)Ljava/lang/String;";
        }
        ClassItem method = ClassItem.findStaticMethod(ser, msigs);
        if (method == null) {
            throw new JiBXException("Serializer " + ser + " not found");
        }
        this.m_serializer = method;
    }

    protected void setWhitespaceConverter(String wsconv) throws JiBXException {
        this.m_converter = ClassItem.findStaticMethod(wsconv, WHITESPACE_CONVERT_SIGNATURES);
        if (this.m_converter == null) {
            throw new JiBXException("Whitespace converter " + wsconv + " not found");
        }
    }

    protected void setDeserializer(String deser) throws JiBXException {
        ClassItem method = ClassItem.findStaticMethod(deser, DESERIALIZER_SIGNATURES);
        if (method == null) {
            throw new JiBXException("Deserializer " + deser + " not found");
        }
        if (!ClassItem.isAssignable(method.getTypeName(), this.m_typeName)) {
            throw new JiBXException("Deserializer " + deser + " returns wrong type");
        }
        this.m_deserializer = method;
    }

    protected abstract Object convertDefault(String var1) throws JiBXException;

    public abstract StringConversion derive(String var1, String var2, String var3, String var4, String var5) throws JiBXException;
}

