/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.ElementMatcher;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamedInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.MURoleChecker;
import org.apache.axiom.soap.impl.common.RoleChecker;
import org.apache.axiom.soap.impl.common.RolePlayerChecker;
import org.apache.axiom.soap.impl.common.SOAPHeaderBlockMapper;
import org.apache.axiom.soap.impl.dom.AxiomSOAPElementImpl;
import org.apache.axiom.soap.impl.intf.AxiomSOAPElement;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeader;

public abstract class AxiomSOAPHeaderImpl
extends AxiomSOAPElementImpl
implements AxiomSOAPHeader,
SOAPHeader,
OMElement,
OMNode,
OMContainer,
OMNamedInformationItem {
    @Override
    public final boolean isChildElementAllowed(OMElement child) {
        return child instanceof SOAPHeaderBlock || !(child instanceof AxiomSOAPElement);
    }

    public final SOAPHeaderBlock addHeaderBlock(String localName, OMNamespace ns) throws OMException {
        SOAPHeaderBlock soapHeaderBlock;
        if (ns == null || ns.getNamespaceURI().length() == 0) {
            throw new OMException("All the SOAP Header blocks should be namespace qualified");
        }
        OMNamespace namespace = this.findNamespace(ns.getNamespaceURI(), ns.getPrefix());
        if (namespace != null) {
            ns = namespace;
        }
        try {
            soapHeaderBlock = ((SOAPFactory)this.getOMFactory()).createSOAPHeaderBlock(localName, ns, (SOAPHeader)this);
        }
        catch (SOAPProcessingException e) {
            throw new OMException((Throwable)e);
        }
        return soapHeaderBlock;
    }

    public final SOAPHeaderBlock addHeaderBlock(QName qname) throws OMException {
        return this.addHeaderBlock(qname.getLocalPart(), this.getOMFactory().createOMNamespace(qname.getNamespaceURI(), qname.getPrefix()));
    }

    public final Iterator<SOAPHeaderBlock> examineAllHeaderBlocks() {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.ANY, null, null, SOAPHeaderBlockMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    public final Iterator<SOAPHeaderBlock> examineHeaderBlocks(String role) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, new RoleChecker(this.getSOAPHelper(), role), null, null, SOAPHeaderBlockMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    public final Iterator<SOAPHeaderBlock> examineMustUnderstandHeaderBlocks(String role) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, new MURoleChecker(this.getSOAPHelper(), role), null, null, SOAPHeaderBlockMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    public final Iterator<SOAPHeaderBlock> getHeadersToProcess(RolePlayer rolePlayer) {
        return this.getHeadersToProcess(rolePlayer, null);
    }

    public final Iterator<SOAPHeaderBlock> getHeadersToProcess(RolePlayer rolePlayer, String namespace) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, new RolePlayerChecker(this.getSOAPHelper(), rolePlayer, namespace), null, null, SOAPHeaderBlockMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    public final Iterator<SOAPHeaderBlock> getHeaderBlocksWithNamespaceURI(String uri) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_NAMESPACE_URI, uri, null, SOAPHeaderBlockMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    public final Iterator<SOAPHeaderBlock> getHeaderBlocksWithName(QName name) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_QNAME, name.getNamespaceURI(), name.getLocalPart(), SOAPHeaderBlockMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    public final ArrayList<SOAPHeaderBlock> getHeaderBlocksWithNSURI(String nsURI) {
        ArrayList<SOAPHeaderBlock> result = new ArrayList<SOAPHeaderBlock>();
        Iterator<SOAPHeaderBlock> it = this.getHeaderBlocksWithNamespaceURI(nsURI);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    private Iterator<SOAPHeaderBlock> extract(Iterator<SOAPHeaderBlock> it) {
        ArrayList<SOAPHeaderBlock> result = new ArrayList<SOAPHeaderBlock>();
        while (it.hasNext()) {
            SOAPHeaderBlock headerBlock = it.next();
            it.remove();
            result.add(headerBlock);
        }
        return result.iterator();
    }

    public final Iterator<SOAPHeaderBlock> extractHeaderBlocks(String role) {
        return this.extract(this.examineHeaderBlocks(role));
    }

    public final Iterator<SOAPHeaderBlock> extractAllHeaderBlocks() {
        return this.extract(this.examineAllHeaderBlocks());
    }
}

