/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.LoggingControl;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.Accept;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.AcksTo;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.Endpoint;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.LastMessageNumber;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.SequenceOffer;
import org.apache.sandesha2.wsrm.TerminateSequence;
import org.apache.sandesha2.wsrm.TerminateSequenceResponse;
import org.apache.sandesha2.wsrm.UsesSequenceSTR;

public class RMMsgCreator {
    private static Log log = LogFactory.getLog(RMMsgCreator.class);
    public static final String ACK_TO_BE_WRITTEN = "ackToBeWritten";

    public static RMMsgContext createCreateSeqMsg(RMSBean rmsBean, RMMsgContext applicationRMMsg) throws AxisFault {
        EndpointReference replyToEPR;
        EndpointReference toEPR;
        Parameter p;
        EndpointReference acksToEPR;
        MessageContext applicationMsgContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::createCreateSeqMsg " + applicationRMMsg));
        }
        if ((applicationMsgContext = applicationRMMsg.getMessageContext()) == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("appMsgIsNull"));
        }
        ConfigurationContext context = applicationMsgContext.getConfigurationContext();
        if (context == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("configContextNotSet"));
        }
        AxisOperation createSequenceOperation = SpecSpecificConstants.getWSRMOperation(1, rmsBean.getRMVersion(), applicationMsgContext.getAxisService());
        MessageContext createSeqmsgContext = SandeshaUtil.createNewRelatedMessageContext(applicationRMMsg, createSequenceOperation);
        OperationContext createSeqOpCtx = createSeqmsgContext.getOperationContext();
        String createSeqMsgId = SandeshaUtil.getUUID();
        createSeqmsgContext.setMessageID(createSeqMsgId);
        context.registerOperationContext(createSeqMsgId, createSeqOpCtx);
        RMMsgContext createSeqRMMsg = new RMMsgContext(createSeqmsgContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmsBean.getRMVersion());
        String addressingNamespace = (String)applicationMsgContext.getProperty("WSAddressingVersion");
        Boolean disableAddressing = (Boolean)applicationMsgContext.getProperty("disableAddressingForOutMessages");
        if (addressingNamespace == null) {
            addressingNamespace = disableAddressing != null && disableAddressing != false ? SpecSpecificConstants.getAddressingNamespace(rmNamespaceValue) : "http://www.w3.org/2005/08/addressing";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("RMMsgCreator:: addressing name space is " + addressingNamespace));
        }
        if ((acksToEPR = rmsBean.getAcksToEndpointReference()) == null) {
            acksToEPR = new EndpointReference(SpecSpecificConstants.getAddressingAnonymousURI(addressingNamespace));
        }
        CreateSequence createSequencePart = new CreateSequence(rmNamespaceValue);
        boolean twoWayService = false;
        AxisService service = applicationMsgContext.getAxisService();
        if (service != null && !JavaUtils.isTrue((Object)applicationMsgContext.getOptions().getProperty("OneWaySequence")) && (p = service.getParameter("ServiceContainsOutInMeps")) != null && p.getValue() != null) {
            twoWayService = (Boolean)p.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("RMMsgCreator:: twoWayService " + twoWayService));
            }
        }
        boolean autoOffer = twoWayService;
        if (applicationMsgContext.getOperationContext() != null && applicationMsgContext.getOperationContext().getAxisOperation() != null && (applicationMsgContext.getOperationContext().getAxisOperation().getAxisSpecificMEPConstant() == 16 || applicationMsgContext.getOperationContext().getAxisOperation().getAxisSpecificMEPConstant() == 17)) {
            autoOffer = true;
        }
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(rmNamespaceValue)) {
            SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean((AxisDescription)context.getAxisConfiguration());
            if (twoWayService && !policy.isEnableMakeConnection()) {
                String message = SandeshaMessageHelper.getMessage("makeConnectionWarning");
                log.warn((Object)message);
            }
        }
        String offeredSequenceId = (String)applicationMsgContext.getProperty("Sandesha2OfferedSequenceId");
        if (autoOffer || offeredSequenceId != null && offeredSequenceId.length() > 0) {
            if (offeredSequenceId == null || offeredSequenceId.length() == 0) {
                offeredSequenceId = SandeshaUtil.getUUID();
            }
            SequenceOffer offerPart = new SequenceOffer(rmNamespaceValue);
            Identifier identifier = new Identifier(rmNamespaceValue);
            identifier.setIndentifer(offeredSequenceId);
            offerPart.setIdentifier(identifier);
            if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(rmNamespaceValue)) {
                EndpointReference offeredEndpoint = (EndpointReference)applicationMsgContext.getProperty("OfferedEndpoint");
                if (offeredEndpoint == null) {
                    offeredEndpoint = rmsBean.getAcksToEndpointReference();
                }
                Endpoint endpoint = new Endpoint(offeredEndpoint, rmNamespaceValue, addressingNamespace);
                offerPart.setEndpoint(endpoint);
            }
            createSequencePart.setSequenceOffer(offerPart);
        }
        if ((toEPR = rmsBean.getToEndpointReference()) == null || toEPR.getAddress() == null) {
            String message = SandeshaMessageHelper.getMessage("toBeanNotSet");
            throw new SandeshaException(message);
        }
        createSeqRMMsg.setTo(toEPR);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RMMsgCreator:: toEPR=" + toEPR));
        }
        if ((replyToEPR = rmsBean.getReplyToEndpointReference()) != null) {
            replyToEPR = SandeshaUtil.getEPRDecorator(createSeqRMMsg.getConfigurationContext()).decorateEndpointReference(replyToEPR);
            createSeqRMMsg.setReplyTo(replyToEPR);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RMMsgCreator:: replyToEPR=" + replyToEPR));
            }
        }
        AcksTo acksTo = new AcksTo(acksToEPR, rmNamespaceValue, addressingNamespace);
        createSequencePart.setAcksTo(acksTo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RMMsgCreator:: acksTo=" + acksTo));
        }
        createSeqRMMsg.setCreateSequence(createSequencePart);
        SecurityManager secMgr = SandeshaUtil.getSecurityManager(context);
        SecurityToken token = secMgr.getSecurityToken(applicationMsgContext);
        if (token != null) {
            OMElement str = secMgr.createSecurityTokenReference(token, createSeqmsgContext);
            createSequencePart.setSecurityTokenReference(str);
            createSeqRMMsg.setProperty("SecurityToken", token);
            if (createSequencePart.getNamespaceValue().equals("http://docs.oasis-open.org/ws-rx/wsrm/200702")) {
                UsesSequenceSTR usesSeqStr = new UsesSequenceSTR();
                usesSeqStr.toHeader(createSeqmsgContext.getEnvelope().getHeader());
            }
            secMgr.applySecurityToken(token, createSeqRMMsg.getMessageContext());
        }
        createSeqRMMsg.setAction(SpecSpecificConstants.getCreateSequenceAction(rmsBean.getRMVersion()));
        createSeqRMMsg.setSOAPAction(SpecSpecificConstants.getCreateSequenceSOAPAction(rmsBean.getRMVersion()));
        createSeqRMMsg.addSOAPEnvelope();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::createCreateSeqMsg " + createSeqRMMsg));
        }
        return createSeqRMMsg;
    }

    public static RMMsgContext createTerminateSequenceMessage(RMMsgContext referenceRMMessage, RMSBean rmsBean, StorageManager storageManager) throws AxisFault {
        MessageContext referenceMessage = referenceRMMessage.getMessageContext();
        if (referenceMessage == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("msgContextNotSet"));
        }
        AxisOperation terminateOperation = SpecSpecificConstants.getWSRMOperation(7, rmsBean.getRMVersion(), referenceMessage.getAxisService());
        ConfigurationContext configCtx = referenceMessage.getConfigurationContext();
        if (configCtx == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("configContextNotSet"));
        }
        MessageContext terminateMessage = SandeshaUtil.createNewRelatedMessageContext(referenceRMMessage, terminateOperation);
        if (terminateMessage == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("msgContextNotSet"));
        }
        if (terminateMessage.getMessageID() == null) {
            terminateMessage.setMessageID(SandeshaUtil.getUUID());
        }
        OperationContext operationContext = terminateMessage.getOperationContext();
        configCtx.registerOperationContext(terminateMessage.getMessageID(), operationContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmsBean.getRMVersion());
        RMMsgContext terminateRMMessage = MsgInitializer.initializeMessage(terminateMessage);
        TerminateSequence terminateSequencePart = new TerminateSequence(rmNamespaceValue);
        Identifier identifier = new Identifier(rmNamespaceValue);
        identifier.setIndentifer(rmsBean.getSequenceID());
        terminateSequencePart.setIdentifier(identifier);
        terminateRMMessage.setTerminateSequence(terminateSequencePart);
        if (TerminateSequence.isLastMsgNumberRequired(rmNamespaceValue)) {
            LastMessageNumber lastMsgNumber = new LastMessageNumber(rmNamespaceValue);
            lastMsgNumber.setMessageNumber(SandeshaUtil.getLastMessageNumber(rmsBean.getInternalSequenceID(), storageManager));
            terminateSequencePart.setLastMessageNumber(lastMsgNumber);
        }
        terminateMessage.setProperty("TRANSPORT_IN", null);
        terminateMessage.setTo(rmsBean.getToEndpointReference());
        RMMsgCreator.secureOutboundMessage(rmsBean, terminateMessage);
        return terminateRMMessage;
    }

    public static RMMsgContext createCreateSeqResponseMsg(RMMsgContext createSeqMessage, RMSequenceBean rmSequenceBean) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::createCreateSeqResponseMsg " + rmSequenceBean));
        }
        CreateSequence cs = createSeqMessage.getCreateSequence();
        String namespace = createSeqMessage.getRMNamespaceValue();
        CreateSequenceResponse response = new CreateSequenceResponse(namespace);
        Identifier identifier = new Identifier(namespace);
        identifier.setIndentifer(rmSequenceBean.getSequenceID());
        response.setIdentifier(identifier);
        SequenceOffer offer = cs.getSequenceOffer();
        if (offer != null) {
            String outSequenceId;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RMMsgCreator:: " + offer));
            }
            if ((outSequenceId = offer.getIdentifer().getIdentifier()) != null && !"".equals(outSequenceId)) {
                Accept accept = new Accept(namespace);
                String addressingNamespace = cs.getAddressingNamespaceValue();
                EndpointReference acksToEPR = createSeqMessage.getTo();
                if (acksToEPR != null) {
                    acksToEPR = SandeshaUtil.cloneEPR(acksToEPR);
                } else {
                    String anon = SpecSpecificConstants.getAddressingAnonymousURI(addressingNamespace);
                    acksToEPR = new EndpointReference(anon);
                }
                AcksTo acksTo = new AcksTo(acksToEPR, namespace, cs.getAddressingNamespaceValue());
                accept.setAcksTo(acksTo);
                response.setAccept(accept);
            }
        }
        String version = SpecSpecificConstants.getSpecVersionString(namespace);
        String action = SpecSpecificConstants.getCreateSequenceResponseAction(version);
        RMMsgContext returnRMContext = RMMsgCreator.createResponseMsg(createSeqMessage, rmSequenceBean, response, 10, action);
        returnRMContext.setTo(createSeqMessage.getReplyTo());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: RMMsgCreator::createCreateSeqResponseMsg " + returnRMContext));
        }
        return returnRMContext;
    }

    public static RMMsgContext createTerminateSeqResponseMsg(RMMsgContext terminateSeqRMMsg, RMSequenceBean rmSequenceBean) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::createTerminateSeqResponseMsg " + rmSequenceBean));
        }
        TerminateSequence terminateSequence = terminateSeqRMMsg.getTerminateSequence();
        String sequenceID = terminateSequence.getIdentifier().getIdentifier();
        String namespace = terminateSeqRMMsg.getRMNamespaceValue();
        TerminateSequenceResponse terminateSequenceResponse = new TerminateSequenceResponse(namespace);
        Identifier identifier = new Identifier(namespace);
        identifier.setIndentifer(sequenceID);
        terminateSequenceResponse.setIdentifier(identifier);
        String version = SpecSpecificConstants.getSpecVersionString(namespace);
        String action = SpecSpecificConstants.getTerminateSequenceResponseAction(version);
        RMMsgContext returnRMContext = RMMsgCreator.createResponseMsg(terminateSeqRMMsg, rmSequenceBean, terminateSequenceResponse, 14, action);
        if (rmSequenceBean.getAcksToEndpointReference() != null) {
            returnRMContext.setTo(rmSequenceBean.getAcksToEndpointReference());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: RMMsgCreator::createTerminateSeqResponseMsg " + returnRMContext));
        }
        return returnRMContext;
    }

    public static RMMsgContext createCloseSeqResponseMsg(RMMsgContext closeSeqRMMsg, RMSequenceBean rmSequenceBean) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::createCloseSeqResponseMsg " + rmSequenceBean));
        }
        CloseSequence closeSequence = closeSeqRMMsg.getCloseSequence();
        String sequenceID = closeSequence.getIdentifier().getIdentifier();
        String namespace = closeSeqRMMsg.getRMNamespaceValue();
        CloseSequenceResponse closeSequenceResponse = new CloseSequenceResponse(namespace);
        Identifier identifier = new Identifier(namespace);
        identifier.setIndentifer(sequenceID);
        closeSequenceResponse.setIdentifier(identifier);
        String version = SpecSpecificConstants.getSpecVersionString(namespace);
        String action = SpecSpecificConstants.getCloseSequenceResponseAction(version);
        RMMsgContext returnRMContext = RMMsgCreator.createResponseMsg(closeSeqRMMsg, rmSequenceBean, closeSequenceResponse, 13, action);
        if (rmSequenceBean.getAcksToEndpointReference() != null) {
            returnRMContext.setTo(rmSequenceBean.getAcksToEndpointReference());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: RMMsgCreator::createCloseSeqResponseMsg " + returnRMContext));
        }
        return returnRMContext;
    }

    private static RMMsgContext createResponseMsg(RMMsgContext requestMsg, RMSequenceBean rmSequenceBean, IOMRMPart part, int messagePartId, String action) throws AxisFault {
        MessageContext outMessage = MessageContextBuilder.createOutMessageContext((MessageContext)requestMsg.getMessageContext());
        RMMsgContext responseRMMsg = new RMMsgContext(outMessage);
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(requestMsg.getSOAPEnvelope()));
        String namespace = requestMsg.getRMNamespaceValue();
        responseRMMsg.setRMNamespaceValue(namespace);
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        responseRMMsg.setSOAPEnvelop(envelope);
        switch (messagePartId) {
            case 13: {
                responseRMMsg.setCloseSequenceResponse((CloseSequenceResponse)part);
                break;
            }
            case 14: {
                responseRMMsg.setTerminateSequenceResponse((TerminateSequenceResponse)part);
                break;
            }
            case 10: {
                responseRMMsg.setCreateSequenceResponse((CreateSequenceResponse)part);
                break;
            }
            default: {
                throw new RuntimeException(SandeshaMessageHelper.getMessage("internalError"));
            }
        }
        outMessage.setWSAAction(action);
        outMessage.setSoapAction(action);
        responseRMMsg.addSOAPEnvelope();
        responseRMMsg.getMessageContext().setServerSide(true);
        RMMsgCreator.secureOutboundMessage(rmSequenceBean, outMessage);
        return responseRMMsg;
    }

    public static void addAckMessage(RMMsgContext applicationMsg, String sequenceId, RMDBean rmdBean, boolean addToEnvelope, boolean isPiggybacked) throws SandeshaException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::addAckMessage " + sequenceId));
        }
        String rmVersion = rmdBean.getRMVersion();
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmVersion);
        ArrayList<Range> ackRangeArrayList = SandeshaUtil.getAckRangeArrayList(rmdBean.getServerCompletedMessages(), rmNamespaceValue);
        if (ackRangeArrayList != null && ackRangeArrayList.size() != 0) {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)("RMMsgCreator::addAckMessage : there are messages to ack " + ackRangeArrayList));
            }
            SequenceAcknowledgement sequenceAck = new SequenceAcknowledgement(rmNamespaceValue, isPiggybacked);
            Identifier id = new Identifier(rmNamespaceValue);
            id.setIndentifer(sequenceId);
            sequenceAck.setIdentifier(id);
            sequenceAck.setAckRanges(ackRangeArrayList);
            if (rmdBean.isClosed()) {
                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                    log.debug((Object)"RMMsgCreator::addAckMessage : sequence closed");
                }
                if (SpecSpecificConstants.isAckFinalAllowed(rmVersion)) {
                    sequenceAck.setAckFinal(true);
                }
            }
            applicationMsg.addSequenceAcknowledgement(sequenceAck);
            if (applicationMsg.getWSAAction() == null) {
                applicationMsg.setAction(SpecSpecificConstants.getSequenceAcknowledgementAction(rmVersion));
                applicationMsg.setSOAPAction(SpecSpecificConstants.getSequenceAcknowledgementSOAPAction(rmVersion));
            }
            if (applicationMsg.getMessageId() == null) {
                applicationMsg.setMessageId(SandeshaUtil.getUUID());
            }
            if (addToEnvelope) {
                try {
                    applicationMsg.addSOAPEnvelope();
                }
                catch (AxisFault e) {
                    if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                        log.debug((Object)"Caught AxisFault", (Throwable)e);
                    }
                    throw new SandeshaException(e.getMessage(), (Exception)((Object)e));
                }
            } else {
                applicationMsg.setProperty(ACK_TO_BE_WRITTEN, Boolean.TRUE);
            }
            RMMsgCreator.secureOutboundMessage(rmdBean, applicationMsg.getMessageContext());
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: RMMsgCreator::addAckMessage " + applicationMsg));
        }
    }

    public static void addAckRequest(RMMsgContext applicationMsg, String sequenceId, RMSBean rmsBean) throws SandeshaException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::addAckRequest " + sequenceId));
        }
        String rmVersion = rmsBean.getRMVersion();
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmVersion);
        AckRequested ackRequest = new AckRequested(rmNamespaceValue);
        Identifier id = new Identifier(rmNamespaceValue);
        id.setIndentifer(sequenceId);
        ackRequest.setIdentifier(id);
        ackRequest.setMustUnderstand(true);
        applicationMsg.addAckRequested(ackRequest);
        if (applicationMsg.getWSAAction() == null) {
            applicationMsg.setAction(SpecSpecificConstants.getAckRequestAction(rmVersion));
            applicationMsg.setSOAPAction(SpecSpecificConstants.getAckRequestSOAPAction(rmVersion));
        }
        if (applicationMsg.getMessageId() == null) {
            applicationMsg.setMessageId(SandeshaUtil.getUUID());
        }
        RMMsgCreator.secureOutboundMessage(rmsBean, applicationMsg.getMessageContext());
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: RMMsgCreator::addAckRequest " + applicationMsg));
        }
    }

    public static RMMsgContext createMakeConnectionMessage(RMMsgContext referenceRMMessage, RMSequenceBean bean, String makeConnectionSeqId, String makeConnectionAnonURI) throws AxisFault {
        EndpointReference epr;
        MessageContext referenceMessage = referenceRMMessage.getMessageContext();
        String rmNamespaceValue = referenceRMMessage.getRMNamespaceValue();
        String rmVersion = referenceRMMessage.getRMSpecVersion();
        AxisOperation makeConnectionOperation = SpecSpecificConstants.getWSRMOperation(11, rmVersion, referenceMessage.getAxisService());
        MessageContext makeConnectionMessageCtx = SandeshaUtil.createNewRelatedMessageContext(referenceRMMessage, makeConnectionOperation);
        RMMsgContext makeConnectionRMMessageCtx = MsgInitializer.initializeMessage(makeConnectionMessageCtx);
        MakeConnection makeConnection = new MakeConnection();
        if (makeConnectionSeqId != null) {
            Identifier identifier = new Identifier(rmNamespaceValue);
            identifier.setIndentifer(makeConnectionSeqId);
            makeConnection.setIdentifier(identifier);
        }
        if (makeConnectionAnonURI != null) {
            makeConnection.setAddress(makeConnectionAnonURI);
        }
        if ((epr = referenceMessage.getTo()).hasAnonymousAddress()) {
            epr = referenceMessage.getReplyTo();
        }
        makeConnectionMessageCtx.setTo(epr);
        makeConnectionMessageCtx.setWSAAction(SpecSpecificConstants.getMakeConnectionAction(rmVersion));
        makeConnectionMessageCtx.setMessageID(SandeshaUtil.getUUID());
        makeConnectionRMMessageCtx.setMakeConnection(makeConnection);
        makeConnectionRMMessageCtx.addSOAPEnvelope();
        RMMsgCreator.secureOutboundMessage(bean, makeConnectionMessageCtx);
        return makeConnectionRMMessageCtx;
    }

    public static void secureOutboundMessage(RMSequenceBean rmBean, MessageContext message) throws SandeshaException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Entry: RMMsgCreator::secureOutboundMessage");
        }
        ConfigurationContext configCtx = message.getConfigurationContext();
        if (rmBean.getSecurityTokenData() != null) {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)"Securing outbound message");
            }
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configCtx);
            SecurityToken token = secManager.recoverSecurityToken(rmBean.getSecurityTokenData());
            secManager.applySecurityToken(token, message);
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Exit: RMMsgCreator::secureOutboundMessage");
        }
    }
}

