/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.Gson;
import com.twitter.common.args.Arg;
import com.twitter.common.args.CmdLine;
import com.twitter.common.base.Command;
import com.twitter.common.base.ExceptionalSupplier;
import com.twitter.common.base.Supplier;
import com.twitter.common.io.Codec;
import com.twitter.common.io.CompatibilityCodec;
import com.twitter.common.io.ThriftCodec;
import com.twitter.common.net.pool.DynamicHostSet;
import com.twitter.common.util.BackoffHelper;
import com.twitter.common.zookeeper.Group;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.common.zookeeper.ServerSets;
import com.twitter.common.zookeeper.ZooKeeperClient;
import com.twitter.thrift.Endpoint;
import com.twitter.thrift.ServiceInstance;
import com.twitter.thrift.Status;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class ServerSetImpl
implements ServerSet {
    private static final Logger LOG = Logger.getLogger(ServerSetImpl.class.getName());
    @CmdLine(name="serverset_encode_json", help="If true, use JSON for encoding server set information. Defaults to true (use JSON).")
    private static final Arg<Boolean> ENCODE_JSON = Arg.create((Object)true);
    private final ZooKeeperClient zkClient;
    private final Group group;
    private final Codec<ServiceInstance> codec;
    private final BackoffHelper backoffHelper;

    public ServerSetImpl(ZooKeeperClient zkClient, String path) {
        this(zkClient, ZooDefs.Ids.OPEN_ACL_UNSAFE, path);
    }

    public ServerSetImpl(ZooKeeperClient zkClient, Iterable<ACL> acl, String path) {
        this(zkClient, new Group(zkClient, acl, path), ServerSetImpl.createDefaultCodec());
    }

    public ServerSetImpl(ZooKeeperClient zkClient, Group group) {
        this(zkClient, group, ServerSetImpl.createDefaultCodec());
    }

    public ServerSetImpl(ZooKeeperClient zkClient, Group group, Codec<ServiceInstance> codec) {
        this.zkClient = (ZooKeeperClient)Preconditions.checkNotNull((Object)zkClient);
        this.group = (Group)Preconditions.checkNotNull((Object)group);
        this.codec = (Codec)Preconditions.checkNotNull(codec);
        this.backoffHelper = new BackoffHelper();
    }

    @VisibleForTesting
    ZooKeeperClient getZkClient() {
        return this.zkClient;
    }

    @Override
    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints) throws Group.JoinException, InterruptedException {
        LOG.log(Level.WARNING, "Joining a ServerSet without a shard ID is deprecated and will soon break.");
        return this.join(endpoint, additionalEndpoints, (Optional<Integer>)Optional.absent());
    }

    @Override
    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints, int shardId) throws Group.JoinException, InterruptedException {
        return this.join(endpoint, additionalEndpoints, (Optional<Integer>)Optional.of((Object)shardId));
    }

    private ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints, Optional<Integer> shardId) throws Group.JoinException, InterruptedException {
        Preconditions.checkNotNull((Object)endpoint);
        Preconditions.checkNotNull(additionalEndpoints);
        final MemberStatus memberStatus = new MemberStatus(endpoint, additionalEndpoints, shardId);
        Supplier<byte[]> serviceInstanceSupplier = new Supplier<byte[]>(){

            public byte[] get() {
                return memberStatus.serializeServiceInstance();
            }
        };
        final Group.Membership membership = this.group.join((com.google.common.base.Supplier)serviceInstanceSupplier);
        return new ServerSet.EndpointStatus(){

            @Override
            public void update(Status status) throws ServerSet.UpdateException {
                Preconditions.checkNotNull((Object)status);
                LOG.warning("This method is deprecated. Please use leave() instead.");
                if (status == Status.DEAD) {
                    this.leave();
                } else {
                    LOG.warning("Status update has been ignored");
                }
            }

            @Override
            public void leave() throws ServerSet.UpdateException {
                memberStatus.leave(membership);
            }
        };
    }

    @Override
    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints, Status status) throws Group.JoinException, InterruptedException {
        LOG.warning("This method is deprecated. Please do not specify a status field.");
        if (status != Status.ALIVE) {
            LOG.severe("**************************************************************************\nWARNING: MUTABLE STATUS FIELDS ARE NO LONGER SUPPORTED.\nJOINING WITH STATUS ALIVE EVEN THOUGH YOU SPECIFIED " + status + "\n**************************************************************************");
        }
        return this.join(endpoint, additionalEndpoints);
    }

    public Command watch(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) throws DynamicHostSet.MonitorException {
        ServerSetWatcher serverSetWatcher = new ServerSetWatcher(this.zkClient, monitor);
        try {
            return serverSetWatcher.watch();
        }
        catch (Group.WatchException e) {
            throw new DynamicHostSet.MonitorException("ZooKeeper watch failed.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new DynamicHostSet.MonitorException("Interrupted while watching ZooKeeper.", (Throwable)e);
        }
    }

    public void monitor(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) throws DynamicHostSet.MonitorException {
        LOG.warning("This method is deprecated. Please use watch instead.");
        this.watch(monitor);
    }

    private static Codec<ServiceInstance> createCodec(final boolean useJsonEncoding) {
        AdaptedJsonCodec json = new AdaptedJsonCodec();
        ThriftCodec thrift = ThriftCodec.create(ServiceInstance.class, (Function)ThriftCodec.BINARY_PROTOCOL);
        Predicate<byte[]> recognizer = new Predicate<byte[]>(){

            public boolean apply(byte[] input) {
                return (input.length > 1 && input[0] == 123 && input[1] == 34) == useJsonEncoding;
            }
        };
        if (useJsonEncoding) {
            return CompatibilityCodec.create((Codec)json, (Codec)thrift, (int)2, (Predicate)recognizer);
        }
        return CompatibilityCodec.create((Codec)thrift, (Codec)json, (int)2, (Predicate)recognizer);
    }

    public static Codec<ServiceInstance> createThriftCodec() {
        return ServerSetImpl.createCodec(false);
    }

    public static Codec<ServiceInstance> createJsonCodec() {
        return ServerSetImpl.createCodec(true);
    }

    public static Codec<ServiceInstance> createDefaultCodec() {
        return ServerSetImpl.createCodec((Boolean)ENCODE_JSON.get());
    }

    private static class AdaptedJsonCodec
    implements Codec<ServiceInstance> {
        private static final Charset ENCODING = Charsets.UTF_8;
        private static final Class<ServiceInstanceSchema> CLASS = ServiceInstanceSchema.class;
        private final Gson gson = new Gson();

        private AdaptedJsonCodec() {
        }

        public void serialize(ServiceInstance instance, OutputStream sink) throws IOException {
            OutputStreamWriter w = new OutputStreamWriter(sink, ENCODING);
            this.gson.toJson((Object)new ServiceInstanceSchema(instance), CLASS, (Appendable)w);
            ((Writer)w).flush();
        }

        public ServiceInstance deserialize(InputStream source) throws IOException {
            ServiceInstanceSchema output = (ServiceInstanceSchema)this.gson.fromJson((Reader)new InputStreamReader(source, ENCODING), CLASS);
            Endpoint primary = new Endpoint(output.getServiceEndpoint().getHost(), output.getServiceEndpoint().getPort().intValue());
            Map additional = Maps.transformValues(output.getAdditionalEndpoints(), (Function)new com.twitter.common.base.Function<EndpointSchema, Endpoint>(){

                public Endpoint apply(EndpointSchema endpoint) {
                    return new Endpoint(endpoint.getHost(), endpoint.getPort().intValue());
                }
            });
            ServiceInstance instance = new ServiceInstance(primary, (Map)ImmutableMap.copyOf((Map)additional), output.getStatus());
            if (output.getShard() != null) {
                instance.setShard(output.getShard().intValue());
            }
            return instance;
        }
    }

    private static class ServiceInstanceSchema {
        final EndpointSchema serviceEndpoint;
        final Map<String, EndpointSchema> additionalEndpoints;
        final Status status;
        final Integer shard;

        ServiceInstanceSchema(ServiceInstance instance) {
            this.serviceEndpoint = new EndpointSchema(instance.getServiceEndpoint());
            this.additionalEndpoints = instance.getAdditionalEndpoints() != null ? Maps.transformValues((Map)instance.getAdditionalEndpoints(), (Function)new com.twitter.common.base.Function<Endpoint, EndpointSchema>(){

                public EndpointSchema apply(Endpoint endpoint) {
                    return new EndpointSchema(endpoint);
                }
            }) : Maps.newHashMap();
            this.status = instance.getStatus();
            this.shard = instance.isSetShard() ? Integer.valueOf(instance.getShard()) : null;
        }

        EndpointSchema getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        Map<String, EndpointSchema> getAdditionalEndpoints() {
            return this.additionalEndpoints;
        }

        Status getStatus() {
            return this.status;
        }

        Integer getShard() {
            return this.shard;
        }
    }

    private static class EndpointSchema {
        final String host;
        final Integer port;

        EndpointSchema(Endpoint endpoint) {
            Preconditions.checkNotNull((Object)endpoint);
            this.host = endpoint.getHost();
            this.port = endpoint.getPort();
        }

        String getHost() {
            return this.host;
        }

        Integer getPort() {
            return this.port;
        }
    }

    private class ServerSetWatcher {
        private final ZooKeeperClient zkClient;
        private final DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor;
        @Nullable
        private ImmutableSet<ServiceInstance> serverSet;
        private final LoadingCache<String, ServiceInstance> servicesByMemberId = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ServiceInstance>(){

            public ServiceInstance load(String memberId) {
                return ServerSetWatcher.this.getServiceInstance(ServerSetImpl.this.group.getMemberPath(memberId));
            }
        });
        private final com.twitter.common.base.Function<String, ServiceInstance> MAYBE_FETCH_NODE = new com.twitter.common.base.Function<String, ServiceInstance>(){

            public ServiceInstance apply(String memberId) {
                try {
                    return (ServiceInstance)ServerSetWatcher.this.servicesByMemberId.getUnchecked((Object)memberId);
                }
                catch (UncheckedExecutionException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof ServiceInstanceDeletedException)) {
                        Throwables.propagateIfInstanceOf((Throwable)cause, ServiceInstanceFetchException.class);
                        throw new IllegalStateException("Unexpected error fetching member data for: " + memberId, e);
                    }
                    return null;
                }
            }
        };

        ServerSetWatcher(ZooKeeperClient zkClient, DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) {
            this.zkClient = zkClient;
            this.monitor = monitor;
        }

        public Command watch() throws Group.WatchException, InterruptedException {
            Watcher onExpirationWatcher = this.zkClient.registerExpirationHandler(new Command(){

                public void execute() {
                    ServerSetWatcher.this.rebuildServerSet();
                }
            });
            try {
                return ServerSetImpl.this.group.watch(new Group.GroupChangeListener(){

                    public void onGroupChange(Iterable<String> memberIds) {
                        ServerSetWatcher.this.notifyGroupChange(memberIds);
                    }
                });
            }
            catch (Group.WatchException e) {
                this.zkClient.unregister(onExpirationWatcher);
                throw e;
            }
            catch (InterruptedException e) {
                this.zkClient.unregister(onExpirationWatcher);
                throw e;
            }
        }

        private ServiceInstance getServiceInstance(final String nodePath) {
            try {
                return (ServiceInstance)ServerSetImpl.this.backoffHelper.doUntilResult((ExceptionalSupplier)new Supplier<ServiceInstance>(){

                    public ServiceInstance get() {
                        try {
                            byte[] data = ServerSetWatcher.this.zkClient.get().getData(nodePath, false, null);
                            return ServerSets.deserializeServiceInstance(data, (Codec<ServiceInstance>)ServerSetImpl.this.codec);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new ServiceInstanceFetchException("Interrupted updating service data for: " + nodePath, e);
                        }
                        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
                            LOG.log(Level.WARNING, "Temporary error trying to updating service data for: " + nodePath, e);
                            return null;
                        }
                        catch (KeeperException.NoNodeException e) {
                            ServerSetWatcher.this.invalidateNodePath(nodePath);
                            throw new ServiceInstanceDeletedException(nodePath);
                        }
                        catch (KeeperException e) {
                            if (ServerSetWatcher.this.zkClient.shouldRetry(e)) {
                                LOG.log(Level.WARNING, "Temporary error trying to update service data for: " + nodePath, e);
                                return null;
                            }
                            throw new ServiceInstanceFetchException("Failed to update service data for: " + nodePath, e);
                        }
                        catch (IOException e) {
                            throw new ServiceInstanceFetchException("Failed to deserialize the ServiceInstance data for: " + nodePath, e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ServiceInstanceFetchException("Interrupted trying to update service data for: " + nodePath, e);
            }
        }

        private void rebuildServerSet() {
            ImmutableSet memberIds = ImmutableSet.copyOf(this.servicesByMemberId.asMap().keySet());
            this.servicesByMemberId.invalidateAll();
            this.notifyGroupChange((Iterable<String>)memberIds);
        }

        private String invalidateNodePath(String deletedPath) {
            String memberId = ServerSetImpl.this.group.getMemberId(deletedPath);
            this.servicesByMemberId.invalidate((Object)memberId);
            return memberId;
        }

        private synchronized void notifyGroupChange(Iterable<String> memberIds) {
            ImmutableSortedSet newMemberIds = ImmutableSortedSet.copyOf(memberIds);
            Set existingMemberIds = this.servicesByMemberId.asMap().keySet();
            if (this.serverSet == null || !newMemberIds.equals(existingMemberIds)) {
                Sets.SetView deletedMemberIds = Sets.difference(existingMemberIds, (Set)newMemberIds);
                existingMemberIds.removeAll((Collection<?>)ImmutableSet.copyOf((Collection)deletedMemberIds));
                Iterable serviceInstances = Iterables.filter((Iterable)Iterables.transform((Iterable)newMemberIds, this.MAYBE_FETCH_NODE), (Predicate)Predicates.notNull());
                this.notifyServerSetChange((ImmutableSet<ServiceInstance>)ImmutableSet.copyOf((Iterable)serviceInstances));
            }
        }

        private void notifyServerSetChange(ImmutableSet<ServiceInstance> currentServerSet) {
            if (!currentServerSet.equals(this.serverSet)) {
                if (currentServerSet.isEmpty()) {
                    LOG.warning("server set empty for path " + ServerSetImpl.this.group.getPath());
                } else if (LOG.isLoggable(Level.INFO)) {
                    if (this.serverSet == null) {
                        LOG.info("received initial membership " + currentServerSet);
                    } else {
                        this.logChange(Level.INFO, currentServerSet);
                    }
                }
                this.serverSet = currentServerSet;
                this.monitor.onChange(this.serverSet);
            }
        }

        private void logChange(Level level, ImmutableSet<ServiceInstance> newServerSet) {
            Sets.SetView joined;
            StringBuilder message = new StringBuilder("server set " + ServerSetImpl.this.group.getPath() + " change: ");
            if (this.serverSet.size() != newServerSet.size()) {
                message.append("from ").append(this.serverSet.size()).append(" members to ").append(newServerSet.size());
            }
            Joiner joiner = Joiner.on((String)"\n\t\t");
            Sets.SetView left = Sets.difference(this.serverSet, newServerSet);
            if (!left.isEmpty()) {
                message.append("\n\tleft:\n\t\t").append(joiner.join((Iterable)left));
            }
            if (!(joined = Sets.difference(newServerSet, this.serverSet)).isEmpty()) {
                message.append("\n\tjoined:\n\t\t").append(joiner.join((Iterable)joined));
            }
            LOG.log(level, message.toString());
        }
    }

    private static class ServiceInstanceDeletedException
    extends RuntimeException {
        ServiceInstanceDeletedException(String path) {
            super(path);
        }
    }

    private static class ServiceInstanceFetchException
    extends RuntimeException {
        ServiceInstanceFetchException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private class MemberStatus {
        private final InetSocketAddress endpoint;
        private final Map<String, InetSocketAddress> additionalEndpoints;
        private final Optional<Integer> shardId;

        private MemberStatus(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints, Optional<Integer> shardId) {
            this.endpoint = endpoint;
            this.additionalEndpoints = additionalEndpoints;
            this.shardId = shardId;
        }

        synchronized void leave(Group.Membership membership) throws ServerSet.UpdateException {
            try {
                membership.cancel();
            }
            catch (Group.JoinException e) {
                throw new ServerSet.UpdateException("Failed to auto-cancel group membership on transition to DEAD status", e);
            }
        }

        byte[] serializeServiceInstance() {
            ServiceInstance serviceInstance = new ServiceInstance(ServerSets.toEndpoint(this.endpoint), Maps.transformValues(this.additionalEndpoints, ServerSets.TO_ENDPOINT), Status.ALIVE);
            if (this.shardId.isPresent()) {
                serviceInstance.setShard(((Integer)this.shardId.get()).intValue());
            }
            LOG.fine("updating endpoint data to:\n\t" + serviceInstance);
            try {
                return ServerSets.serializeServiceInstance(serviceInstance, (Codec<ServiceInstance>)ServerSetImpl.this.codec);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected problem serializing thrift struct " + serviceInstance + "to a byte[]", e);
            }
        }
    }
}

