/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.feature;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.commons.lang.StringUtils;

public abstract class CacheableFeatureProvider<T extends Feature>
implements FeatureProvider {
    protected final String scope;
    protected final ConcurrentMap<String, FeatureProvider> scopes = new ConcurrentHashMap<String, FeatureProvider>();
    protected final ConcurrentMap<String, T> features = new ConcurrentHashMap<String, T>();

    protected CacheableFeatureProvider(String scope) {
        this.scope = scope;
    }

    protected String makeName(String name) {
        if (StringUtils.isBlank((String)this.scope)) {
            return name;
        }
        return this.scope + "." + name;
    }

    public T getFeature(String name) {
        Feature feature = (Feature)this.features.get(name);
        if (null == feature) {
            T newFeature = this.makeFeature(this.makeName(name));
            Feature oldFeature = (Feature)this.features.putIfAbsent(name, newFeature);
            feature = null == oldFeature ? newFeature : oldFeature;
        }
        return (T)feature;
    }

    protected abstract T makeFeature(String var1);

    @Override
    public FeatureProvider scope(String name) {
        FeatureProvider provider = (FeatureProvider)this.scopes.get(name);
        if (null == provider) {
            FeatureProvider newProvider = this.makeProvider(this.makeName(name));
            FeatureProvider oldProvider = this.scopes.putIfAbsent(name, newProvider);
            provider = null == oldProvider ? newProvider : oldProvider;
        }
        return provider;
    }

    protected abstract FeatureProvider makeProvider(String var1);
}

