/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools;

import java.io.IOException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.zookeeper.KeeperException;

public class BookKeeperTools {
    public static void main(String[] args) throws InterruptedException, IOException, KeeperException, BKException {
        if (args.length < 2) {
            System.err.println("USAGE: BookKeeperTools zkServers bookieSrc [bookieDest]");
            return;
        }
        String zkServers = args[0];
        String[] bookieSrcString = args[1].split(":");
        if (bookieSrcString.length < 2) {
            System.err.println("BookieSrc inputted has invalid name format (host:port expected): " + args[1]);
            return;
        }
        BookieSocketAddress bookieSrc = new BookieSocketAddress(bookieSrcString[0], Integer.parseInt(bookieSrcString[1]));
        BookieSocketAddress bookieDest = null;
        if (args.length > 2) {
            String[] bookieDestString = args[2].split(":");
            if (bookieDestString.length < 2) {
                System.err.println("BookieDest inputted has invalid name format (host:port expected): " + args[2]);
                return;
            }
            bookieDest = new BookieSocketAddress(bookieDestString[0], Integer.parseInt(bookieDestString[1]));
        }
        BookKeeperAdmin bkTools = new BookKeeperAdmin(zkServers);
        bkTools.recoverBookieData(bookieSrc, bookieDest);
        bkTools.close();
    }
}

