/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.namespace;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceDriverManager {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceDriverManager.class);
    private static final ConcurrentMap<String, NamespaceDriverInfo> drivers;
    private static boolean initialized;

    static void initialize() {
        if (initialized) {
            return;
        }
        NamespaceDriverManager.loadInitialDrivers();
        initialized = true;
        logger.info("DistributedLog NamespaceDriverManager initialized");
    }

    private static void loadInitialDrivers() {
        HashSet driverList = Sets.newHashSet();
        driverList.add(BKNamespaceDriver.class.getName());
        String driversStr = System.getProperty("distributedlog.namespace.drivers");
        if (null != driversStr) {
            String[] driversArray;
            for (String driver : driversArray = StringUtils.split((String)driversStr, (char)':')) {
                driverList.add(driver);
            }
        }
        for (String driverClsName : driverList) {
            try {
                NamespaceDriver driver = (NamespaceDriver)ReflectionUtils.newInstance((String)driverClsName, NamespaceDriver.class);
                NamespaceDriverInfo driverInfo = new NamespaceDriverInfo(driver.getClass());
                drivers.put(driver.getScheme().toLowerCase(), driverInfo);
            }
            catch (Exception ex) {
                logger.warn("Failed to load namespace driver {} : ", (Object)driverClsName, (Object)ex);
            }
        }
    }

    private NamespaceDriverManager() {
    }

    public static void registerDriver(String backend, Class<? extends NamespaceDriver> driver) {
        String scheme;
        NamespaceDriverInfo oldDriverInfo;
        if (!initialized) {
            NamespaceDriverManager.initialize();
        }
        if (null != (oldDriverInfo = (NamespaceDriverInfo)drivers.get(scheme = backend.toLowerCase()))) {
            return;
        }
        NamespaceDriverInfo newDriverInfo = new NamespaceDriverInfo(driver);
        oldDriverInfo = drivers.putIfAbsent(scheme, newDriverInfo);
        if (null != oldDriverInfo) {
            logger.debug("Driver for {} is already there.", (Object)scheme);
        }
    }

    public static NamespaceDriver getDriver(String scheme) {
        NamespaceDriverInfo driverInfo;
        Preconditions.checkNotNull((Object)scheme, (Object)"Driver Scheme is null");
        if (!initialized) {
            NamespaceDriverManager.initialize();
        }
        if (null == (driverInfo = (NamespaceDriverInfo)drivers.get(scheme.toLowerCase()))) {
            throw new IllegalArgumentException("Unknown backend " + scheme);
        }
        return (NamespaceDriver)ReflectionUtils.newInstance(driverInfo.driverClass);
    }

    public static NamespaceDriver getDriver(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"DistributedLog uri is null");
        String scheme = uri.getScheme();
        Preconditions.checkNotNull((Object)scheme, (Object)("Invalid distributedlog uri : " + uri));
        scheme = scheme.toLowerCase();
        String[] schemeParts = StringUtils.split((String)scheme, (char)'-');
        Preconditions.checkArgument((schemeParts.length > 0 ? 1 : 0) != 0, (Object)("Invalid distributedlog scheme found : " + uri));
        Preconditions.checkArgument((boolean)Objects.equal((Object)"distributedlog", (Object)schemeParts[0].toLowerCase()), (Object)("Unknown distributedlog scheme found : " + uri));
        String backend = "bk";
        if (schemeParts.length > 1) {
            backend = schemeParts[1];
        }
        return NamespaceDriverManager.getDriver(backend);
    }

    static {
        initialized = false;
        drivers = new ConcurrentHashMap<String, NamespaceDriverInfo>();
        NamespaceDriverManager.initialize();
    }

    static class NamespaceDriverInfo {
        final Class<? extends NamespaceDriver> driverClass;
        final String driverClassName;

        NamespaceDriverInfo(Class<? extends NamespaceDriver> driverClass) {
            this.driverClass = driverClass;
            this.driverClassName = this.driverClass.getName();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("driver[").append(this.driverClassName).append("]");
            return sb.toString();
        }
    }
}

