/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.qpid;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.entity.java.JmxSupport;
import org.apache.brooklyn.entity.messaging.jms.JMSBrokerImpl;
import org.apache.brooklyn.entity.messaging.qpid.QpidBroker;
import org.apache.brooklyn.entity.messaging.qpid.QpidDriver;
import org.apache.brooklyn.entity.messaging.qpid.QpidQueue;
import org.apache.brooklyn.entity.messaging.qpid.QpidTopic;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidBrokerImpl
extends JMSBrokerImpl<QpidQueue, QpidTopic>
implements QpidBroker {
    private static final Logger log = LoggerFactory.getLogger(QpidBrokerImpl.class);
    private volatile JmxFeed jmxFeed;

    @Override
    public String getVirtualHost() {
        return (String)this.getAttribute((AttributeSensor)VIRTUAL_HOST_NAME);
    }

    @Override
    public String getAmqpVersion() {
        return (String)this.getAttribute((AttributeSensor)AMQP_VERSION);
    }

    @Override
    public Integer getAmqpPort() {
        return (Integer)this.getAttribute((AttributeSensor)AMQP_PORT);
    }

    @Override
    public void setBrokerUrl() {
        String urlFormat = "amqp://guest:guest@/%s?brokerlist='tcp://%s:%d'";
        this.sensors().set(BROKER_URL, (Object)String.format(urlFormat, this.getAttribute((AttributeSensor)VIRTUAL_HOST_NAME), this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)AMQP_PORT)));
    }

    public void init() {
        super.init();
        new JmxSupport((Entity)this, null).recommendJmxRmiCustomAgent();
    }

    public void waitForServiceUp(long duration, TimeUnit units) {
        super.waitForServiceUp(duration, units);
        JmxHelper helper = new JmxHelper((Entity)this);
        try {
            String virtualHost = (String)this.getConfig((ConfigKey.HasConfigKey)QpidBroker.VIRTUAL_HOST_NAME);
            ObjectName virtualHostManager = new ObjectName(String.format("org.apache.qpid:type=VirtualHost.VirtualHostManager,VirtualHost=\"%s\"", virtualHost));
            helper.connect();
            helper.assertMBeanExistsEventually(virtualHostManager, units.toMillis(duration));
        }
        catch (MalformedObjectNameException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            if (helper != null) {
                helper.terminate();
            }
        }
    }

    @Override
    public QpidQueue createQueue(Map properties) {
        QpidQueue result = (QpidQueue)this.addChild((EntitySpec)EntitySpec.create(QpidQueue.class).configure(properties));
        result.create();
        return result;
    }

    @Override
    public QpidTopic createTopic(Map properties) {
        QpidTopic result = (QpidTopic)this.addChild((EntitySpec)EntitySpec.create(QpidTopic.class).configure(properties));
        result.create();
        return result;
    }

    public Class getDriverInterface() {
        return QpidDriver.class;
    }

    @Override
    protected void connectSensors() {
        super.connectSensors();
        String serverInfoMBeanName = "org.apache.qpid:type=ServerInformation,name=ServerInformation";
        this.jmxFeed = JmxFeed.builder().entity((Entity)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_UP).objectName(serverInfoMBeanName).attributeName("ProductVersion").onSuccess((Function)new Function<Object, Boolean>(){
            private boolean hasWarnedOfVersionMismatch;

            public Boolean apply(Object input) {
                if (input == null) {
                    return false;
                }
                if (!this.hasWarnedOfVersionMismatch && !((String)QpidBrokerImpl.this.getConfig(QpidBroker.SUGGESTED_VERSION)).equals(input)) {
                    log.warn("Qpid version mismatch: ProductVersion is {}, requested version is {}", input, QpidBrokerImpl.this.getConfig(QpidBroker.SUGGESTED_VERSION));
                    this.hasWarnedOfVersionMismatch = true;
                }
                return true;
            }
        })).onException(Functions.constant((Object)false))).suppressDuplicates(true)).build();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("amqpPort", (Object)this.getAmqpPort());
    }
}

