/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.BrooklynObjectPredicate;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;

public class ResourcePredicates {
    private ResourcePredicates() {
    }

    public static Predicate<String> urlExists() {
        return new ResourceExistsPredicate();
    }

    public static Predicate<String> urlIsBlankOrExists() {
        return Predicates.or((Predicate)StringPredicates.isBlank(), ResourcePredicates.urlExists());
    }

    private static class ResourceExistsPredicate
    implements BrooklynObjectPredicate<String> {
        private ResourceExistsPredicate() {
        }

        public boolean apply(@Nullable String resource) {
            return this.apply(resource, (BrooklynObject)BrooklynTaskTags.getContextEntity(Tasks.current()));
        }

        @Override
        public boolean apply(@Nullable String resource, @Nullable BrooklynObject context) {
            return !Strings.isBlank((CharSequence)resource) && new ResourceUtils(context).doesUrlExist(resource);
        }

        public String toString() {
            return "ResourcePredicates.urlExists()";
        }
    }
}

