/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.osgi;

import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class Compat {
    private final ServiceTracker managementContextTracker;

    public static Compat getInstance() {
        return SingletonHolder.instance;
    }

    private Compat() {
        Bundle bundle = FrameworkUtil.getBundle(Compat.class);
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            this.managementContextTracker = new ServiceTracker(bundleContext, ManagementContext.class, null);
            this.managementContextTracker.open();
        } else {
            this.managementContextTracker = null;
        }
    }

    public ManagementContext getManagementContext() {
        if (this.managementContextTracker != null) {
            return (ManagementContext)this.managementContextTracker.getService();
        }
        return null;
    }

    private static class SingletonHolder {
        private static final Compat instance = new Compat();

        private SingletonHolder() {
        }
    }
}

