/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.brooklyn.rest.domain.TaskSummary;

@Path(value="/activities")
@Api(value="Activities")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ActivityApi {
    @GET
    @Path(value="/{task}")
    @ApiOperation(value="Fetch task details", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find task")})
    public TaskSummary get(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1);

    @GET
    @Path(value="/{task}/children")
    @ApiOperation(value="Fetch list of children tasks of this task")
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find task")})
    public List<TaskSummary> children(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Whether to include non-subtask backgrounded tasks submitted by this task", required=false) @QueryParam(value="includeBackground") @DefaultValue(value="false") Boolean var2);

    @GET
    @Path(value="/{task}/children/recurse")
    @ApiOperation(value="Fetch all child tasks and their descendants with details as Map<String,TaskSummary> map key == Task ID", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find task")})
    public Map<String, TaskSummary> getAllChildrenAsMap(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Max number of tasks to include, or -1 for all (default 200)", required=false) @QueryParam(value="limit") @DefaultValue(value="200") int var2, @ApiParam(value="Max depth to traverse, or -1 for all (default)", required=false) @QueryParam(value="maxDepth") @DefaultValue(value="-1") int var3);

    @GET
    @Path(value="/{task}/children/recurse/deprecated")
    @ApiOperation(value="Fetch all child tasks details as Map<String,TaskSummary> map key == Task ID", response=Map.class)
    @Deprecated
    public Map<String, TaskSummary> getAllChildrenAsMap(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1);

    @GET
    @Path(value="/{task}/stream/{streamId}")
    @ApiOperation(value="Return the contents of the given stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Could not find task or stream")})
    @Produces(value={"text/plain"})
    public String stream(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Stream ID", required=true) @PathParam(value="streamId") String var2);
}

