/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class DescribeSpotPriceHistoryOptions
extends BaseEC2RequestOptions {
    public static final DescribeSpotPriceHistoryOptions NONE = new DescribeSpotPriceHistoryOptions();
    private static final DateService service = new SimpleDateFormatDateService();

    public DescribeSpotPriceHistoryOptions from(Date start) {
        this.formParameters.put((Object)"StartTime", (Object)service.iso8601DateFormat((Date)Preconditions.checkNotNull((Object)start, (Object)"start")));
        return this;
    }

    public DescribeSpotPriceHistoryOptions to(Date end) {
        this.formParameters.put((Object)"EndTime", (Object)service.iso8601DateFormat((Date)Preconditions.checkNotNull((Object)end, (Object)"end")));
        return this;
    }

    public DescribeSpotPriceHistoryOptions instanceType(String type) {
        this.formParameters.put((Object)"InstanceType.1", Preconditions.checkNotNull((Object)type, (Object)"type"));
        return this;
    }

    public DescribeSpotPriceHistoryOptions productDescription(String description) {
        this.formParameters.put((Object)"ProductDescription", Preconditions.checkNotNull((Object)description, (Object)"description"));
        return this;
    }

    public static class Builder {
        public static DescribeSpotPriceHistoryOptions from(Date start) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.from(start);
        }

        public static DescribeSpotPriceHistoryOptions to(Date end) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.to(end);
        }

        public static DescribeSpotPriceHistoryOptions instanceType(String instanceType) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.instanceType(instanceType);
        }

        public static DescribeSpotPriceHistoryOptions productDescription(String description) {
            DescribeSpotPriceHistoryOptions options = new DescribeSpotPriceHistoryOptions();
            return options.productDescription(description);
        }
    }
}

