/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.camp.server.dto.LinkDto;
import org.apache.brooklyn.camp.server.dto.ResourceDto;
import org.apache.brooklyn.camp.server.rest.util.DtoFactory;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.ApplicationComponent;
import org.apache.brooklyn.camp.spi.Link;
import org.apache.brooklyn.camp.spi.PlatformComponent;

public class PlatformComponentDto
extends ResourceDto {
    private List<LinkDto> platformComponents;
    private List<LinkDto> applicationComponents;
    private String externalManagementUri;

    protected PlatformComponentDto() {
    }

    protected PlatformComponentDto(DtoFactory dtoFactory, PlatformComponent x) {
        super(dtoFactory, (AbstractResource)x);
        this.setExternalManagementUri(x.getExternalManagementUri());
        this.platformComponents = new ArrayList<LinkDto>();
        for (Link t : x.getPlatformComponents().links()) {
            this.platformComponents.add(LinkDto.newInstance(dtoFactory, PlatformComponent.class, t));
        }
        this.applicationComponents = new ArrayList<LinkDto>();
        for (Link t : x.getApplicationComponents().links()) {
            this.applicationComponents.add(LinkDto.newInstance(dtoFactory, ApplicationComponent.class, t));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LinkDto> getPlatformComponents() {
        return this.platformComponents;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LinkDto> getApplicationComponents() {
        return this.applicationComponents;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getExternalManagementUri() {
        return this.externalManagementUri;
    }

    private void setExternalManagementUri(String externalManagementUri) {
        this.externalManagementUri = externalManagementUri;
    }

    public static PlatformComponentDto newInstance(DtoFactory dtoFactory, PlatformComponent x) {
        return new PlatformComponentDto(dtoFactory, x);
    }
}

