/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.TagImportPolicy;
import io.fabric8.openshift.api.model.TagImportPolicyBuilder;
import io.fabric8.openshift.api.model.TagImportPolicyFluentImpl;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class TagReferenceFluentImpl<A extends TagReferenceFluent<A>>
extends BaseFluent<A>
implements TagReferenceFluent<A> {
    private Map<String, String> annotations = new LinkedHashMap<String, String>();
    private VisitableBuilder<? extends ObjectReference, ?> from;
    private Long generation;
    private VisitableBuilder<? extends TagImportPolicy, ?> importPolicy;
    private String name;
    private Boolean reference;

    public TagReferenceFluentImpl() {
    }

    public TagReferenceFluentImpl(TagReference instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withFrom(instance.getFrom());
        this.withGeneration(instance.getGeneration());
        this.withImportPolicy(instance.getImportPolicy());
        this.withName(instance.getName());
        this.withReference(instance.getReference());
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (key != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public A withAnnotations(Map<String, String> annotations) {
        this.annotations.clear();
        if (annotations != null) {
            this.annotations.putAll(annotations);
        }
        return (A)this;
    }

    @Override
    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public TagReferenceFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public TagReferenceFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public TagReferenceFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public TagReferenceFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public TagReferenceFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public TagImportPolicy getImportPolicy() {
        return this.importPolicy != null ? (TagImportPolicy)this.importPolicy.build() : null;
    }

    @Override
    public A withImportPolicy(TagImportPolicy importPolicy) {
        this._visitables.remove(this.importPolicy);
        if (importPolicy != null) {
            this.importPolicy = new TagImportPolicyBuilder(importPolicy);
            this._visitables.add(this.importPolicy);
        }
        return (A)this;
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicy() {
        return new ImportPolicyNestedImpl();
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
        return new ImportPolicyNestedImpl(item);
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> editImportPolicy() {
        return this.withNewImportPolicyLike(this.getImportPolicy());
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> editOrNewImportPolicy() {
        return this.withNewImportPolicyLike(this.getImportPolicy() != null ? this.getImportPolicy() : new TagImportPolicyBuilder().build());
    }

    @Override
    public TagReferenceFluent.ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
        return this.withNewImportPolicyLike(this.getImportPolicy() != null ? this.getImportPolicy() : item);
    }

    @Override
    public A withNewImportPolicy(Boolean insecure, Boolean scheduled) {
        return this.withImportPolicy(new TagImportPolicy(insecure, scheduled));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean isReference() {
        return this.reference;
    }

    @Override
    public A withReference(Boolean reference) {
        this.reference = reference;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagReferenceFluentImpl that = (TagReferenceFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) {
            return false;
        }
        if (this.importPolicy != null ? !this.importPolicy.equals(that.importPolicy) : that.importPolicy != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.reference != null ? !this.reference.equals(that.reference) : that.reference != null);
    }

    public class ImportPolicyNestedImpl<N>
    extends TagImportPolicyFluentImpl<TagReferenceFluent.ImportPolicyNested<N>>
    implements TagReferenceFluent.ImportPolicyNested<N>,
    Nested<N> {
        private final TagImportPolicyBuilder builder;

        ImportPolicyNestedImpl(TagImportPolicy item) {
            this.builder = new TagImportPolicyBuilder(this, item);
        }

        ImportPolicyNestedImpl() {
            this.builder = new TagImportPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)TagReferenceFluentImpl.this.withImportPolicy(this.builder.build());
        }

        @Override
        public N endImportPolicy() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<TagReferenceFluent.FromNested<N>>
    implements TagReferenceFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)TagReferenceFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

