/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.entity.java.JavaAppUtils;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.webapp.HttpsSslConfig;
import org.apache.brooklyn.entity.webapp.JavaWebAppDriver;
import org.apache.brooklyn.entity.webapp.JavaWebAppService;
import org.apache.brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import org.apache.brooklyn.entity.webapp.WebAppServiceMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaWebAppSoftwareProcessImpl
extends SoftwareProcessImpl
implements JavaWebAppService,
JavaWebAppSoftwareProcess {
    private static final Logger LOG = LoggerFactory.getLogger(JavaWebAppSoftwareProcessImpl.class);

    public void init() {
        super.init();
        WebAppServiceMethods.connectWebAppServerPolicies(this);
        JavaAppUtils.connectJavaAppServerPolicies((Entity)this);
    }

    public JavaWebAppDriver getDriver() {
        return (JavaWebAppDriver)super.getDriver();
    }

    public void deployInitialWars() {
        String rootWar;
        if (this.getAttribute(DEPLOYED_WARS) == null) {
            this.sensors().set(DEPLOYED_WARS, (Object)Sets.newLinkedHashSet());
        }
        if ((rootWar = (String)this.getConfig(ROOT_WAR)) != null) {
            this.deploy(rootWar, "ROOT.war");
        }
        List namedWars = (List)this.getConfig(NAMED_WARS, Collections.emptyList());
        for (String war : namedWars) {
            this.deploy(war, this.getDriver().getFilenameContextMapper().findArchiveNameFromUrl(war, true));
        }
        Map warsByContext = (Map)this.getConfig(WARS_BY_CONTEXT);
        if (warsByContext != null) {
            for (String context : warsByContext.keySet()) {
                this.deploy((String)warsByContext.get(context), context);
            }
        }
    }

    @Override
    @Effector(description="Deploys the given artifact, from a source URL, to a given deployment filename/context")
    public void deploy(@EffectorParam(name="url", description="URL of WAR file") String url, @EffectorParam(name="targetName", description="context path where WAR should be deployed (/ for ROOT)") String targetName) {
        try {
            Preconditions.checkNotNull((Object)url, (Object)"url");
            Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
            JavaWebAppDriver driver = this.getDriver();
            String deployedName = driver.deploy(url, targetName);
            Set deployedWars = (Set)this.getAttribute(DEPLOYED_WARS);
            if (deployedWars == null) {
                deployedWars = Sets.newLinkedHashSet();
            }
            deployedWars.add(deployedName);
            this.sensors().set(DEPLOYED_WARS, (Object)deployedWars);
        }
        catch (RuntimeException e) {
            LOG.warn("Error deploying '" + url + "' to " + targetName + " on " + this.toString() + "; rethrowing...", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    @Effector(description="Undeploys the given context/artifact")
    public void undeploy(@EffectorParam(name="targetName") String targetName) {
        try {
            JavaWebAppDriver driver = this.getDriver();
            driver.undeploy(targetName);
            Set deployedWars = (Set)this.getAttribute(DEPLOYED_WARS);
            if (deployedWars == null) {
                deployedWars = Sets.newLinkedHashSet();
            }
            deployedWars.remove(driver.getFilenameContextMapper().convertDeploymentTargetNameToContext(targetName));
            this.sensors().set(DEPLOYED_WARS, (Object)deployedWars);
        }
        catch (RuntimeException e) {
            LOG.warn("Error undeploying '" + targetName + "' on " + this.toString() + "; rethrowing...", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void postStop() {
        super.postStop();
        this.sensors().set(REQUESTS_PER_SECOND_LAST, (Object)0.0);
        this.sensors().set(REQUESTS_PER_SECOND_IN_WINDOW, (Object)0.0);
    }

    @Override
    public boolean isHttpEnabled() {
        return WebAppServiceMethods.isProtocolEnabled(this, "HTTP");
    }

    @Override
    public boolean isHttpsEnabled() {
        return WebAppServiceMethods.isProtocolEnabled(this, "HTTPS");
    }

    @Override
    public Integer getHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)HTTP_PORT);
    }

    @Override
    public Integer getHttpsPort() {
        return (Integer)this.getAttribute((AttributeSensor)HTTPS_PORT);
    }

    @Override
    public String getHttpsSslKeyAlias() {
        HttpsSslConfig config = (HttpsSslConfig)this.getAttribute((AttributeSensor)HTTPS_SSL_CONFIG);
        return config == null ? null : config.getKeyAlias();
    }

    @Override
    public String getHttpsSslKeystorePassword() {
        HttpsSslConfig config = (HttpsSslConfig)this.getAttribute((AttributeSensor)HTTPS_SSL_CONFIG);
        return config == null ? "" : config.getKeystorePassword();
    }
}

