/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.entity;

import com.google.common.base.Objects;
import java.util.Set;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.resolve.entity.AbstractEntitySpecResolver;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogEntitySpecResolver
extends AbstractEntitySpecResolver {
    private static final Logger log = LoggerFactory.getLogger(CatalogEntitySpecResolver.class);
    private static final String RESOLVER_NAME = "catalog";

    public CatalogEntitySpecResolver() {
        super(RESOLVER_NAME);
    }

    private RegisteredType loadUpgrade(String type) {
        String upgradedType = BundleUpgradeParser.CatalogUpgrades.getTypeUpgradedIfNecessary(this.mgmt, type);
        if (!Objects.equal((Object)type, (Object)upgradedType)) {
            if (log.isTraceEnabled()) {
                log.trace("Using " + upgradedType + " in request for " + type);
            }
            return this.mgmt.getTypeRegistry().get(upgradedType);
        }
        return null;
    }

    @Override
    protected boolean canResolve(String type, BrooklynClassLoadingContext loader) {
        String localType = this.getLocalType(type);
        RegisteredType item = this.mgmt.getTypeRegistry().get(localType);
        if (item == null) {
            item = this.loadUpgrade(localType);
        }
        if (item == null) {
            return false;
        }
        return !item.isDisabled();
    }

    @Override
    public EntitySpec<?> resolve(String type, BrooklynClassLoadingContext loader, Set<String> parentEncounteredTypes) {
        boolean upgradeRequired;
        String localType = this.getLocalType(type);
        RegisteredType item = this.mgmt.getTypeRegistry().get(localType);
        boolean bl = upgradeRequired = item == null;
        if (upgradeRequired) {
            item = this.loadUpgrade(localType);
        }
        if (item == null) {
            return null;
        }
        this.checkUsable(item);
        boolean recursiveCall = parentEncounteredTypes.contains(item.getSymbolicName());
        if (recursiveCall) {
            return null;
        }
        EntitySpec result = (EntitySpec)this.mgmt.getTypeRegistry().createSpec(item, RegisteredTypeLoadingContexts.alreadyEncountered(parentEncounteredTypes), EntitySpec.class);
        if (upgradeRequired) {
            result.tag((Object)BrooklynTags.newUpgradedFromTag(localType));
        }
        return result;
    }

    private void checkUsable(RegisteredType item) {
        if (item.isDisabled()) {
            throw new IllegalStateException("Illegal use of disabled catalog item " + item.getSymbolicName() + ":" + item.getVersion());
        }
        if (item.isDeprecated()) {
            log.warn("Use of deprecated catalog item " + item.getSymbolicName() + ":" + item.getVersion());
        }
    }
}

