/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.ssh.sshj;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.internal.ssh.SshAbstractTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshjClientConnection
implements SshAbstractTool.SshAction<SSHClient> {
    private static final Logger LOG = LoggerFactory.getLogger(SshjClientConnection.class);
    private final HostAndPort hostAndPort;
    private final String username;
    private final String password;
    private final String privateKeyPassphrase;
    private final String privateKeyData;
    private final File privateKeyFile;
    private final boolean strictHostKeyChecking;
    private final int connectTimeout;
    private final int sessionTimeout;
    SSHClient ssh;

    public static Builder builder() {
        return new Builder();
    }

    private SshjClientConnection(Builder builder) {
        this.hostAndPort = (HostAndPort)Preconditions.checkNotNull((Object)builder.hostAndPort);
        this.username = builder.username;
        this.password = builder.password;
        this.privateKeyPassphrase = builder.privateKeyPassphrase;
        this.privateKeyData = builder.privateKeyData;
        this.privateKeyFile = builder.privateKeyFile;
        this.strictHostKeyChecking = builder.strictHostKeyChecking;
        this.connectTimeout = SshjClientConnection.checkInt("connectTimeout", builder.connectTimeout, Integer.MAX_VALUE);
        this.sessionTimeout = SshjClientConnection.checkInt("sessionTimeout", builder.sessionTimeout, Integer.MAX_VALUE);
    }

    static Integer checkInt(String context, long value, Integer ifTooLarge) {
        if (value > Integer.MAX_VALUE) {
            LOG.warn("Value '" + value + "' for " + context + " too large in SshjClientConnection; using " + value);
            return ifTooLarge;
        }
        return (int)value;
    }

    public boolean isConnected() {
        return this.ssh != null && this.ssh.isConnected();
    }

    public boolean isAuthenticated() {
        return this.ssh != null && this.ssh.isAuthenticated();
    }

    @Override
    public void clear() {
        block4: {
            if (this.ssh != null && this.ssh.isConnected()) {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Disconnecting SshjClientConnection {} ({})", (Object)this, (Object)System.identityHashCode(this));
                    }
                    this.ssh.disconnect();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("<< exception disconnecting from {}: {}", (Object)e, (Object)e.getMessage());
                }
            }
        }
        this.ssh = null;
    }

    @Override
    public SSHClient create() throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Connecting SshjClientConnection {} ({})", (Object)this, (Object)System.identityHashCode(this));
        }
        this.ssh = new SSHClient();
        if (!this.strictHostKeyChecking) {
            this.ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
        if (this.connectTimeout != 0) {
            this.ssh.setConnectTimeout(this.connectTimeout);
        }
        if (this.sessionTimeout != 0) {
            this.ssh.setTimeout(this.sessionTimeout);
        }
        this.ssh.connect(this.hostAndPort.getHostText(), this.hostAndPort.getPortOrDefault(22));
        if (this.password != null) {
            this.ssh.authPassword(this.username, this.password);
        } else if (this.privateKeyData != null) {
            OpenSSHKeyFile key = new OpenSSHKeyFile();
            key.init(this.privateKeyData, null, JavaGroovyEquivalents.groovyTruth((String)this.privateKeyPassphrase) ? PasswordUtils.createOneOff((char[])this.privateKeyPassphrase.toCharArray()) : null);
            this.ssh.authPublickey(this.username, new KeyProvider[]{key});
        } else if (this.privateKeyFile != null) {
            OpenSSHKeyFile key = new OpenSSHKeyFile();
            key.init(this.privateKeyFile, JavaGroovyEquivalents.groovyTruth((String)this.privateKeyPassphrase) ? PasswordUtils.createOneOff((char[])this.privateKeyPassphrase.toCharArray()) : null);
            this.ssh.authPublickey(this.username, new KeyProvider[]{key});
        } else {
            this.ssh.authPublickey(this.username);
        }
        return this.ssh;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public String getUsername() {
        return this.username;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public SSHClient getSSHClient() {
        return this.ssh;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshjClientConnection that = (SshjClientConnection)SshjClientConnection.class.cast(o);
        return Objects.equal((Object)this.hostAndPort, (Object)that.hostAndPort) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.privateKeyData, (Object)that.privateKeyData) && Objects.equal((Object)this.privateKeyFile, (Object)that.privateKeyFile) && Objects.equal((Object)this.ssh, (Object)that.ssh);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostAndPort, this.username, this.password, this.privateKeyData, this.ssh});
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("hostAndPort", (Object)this.hostAndPort).add("user", (Object)this.username).add("ssh", this.ssh != null ? Integer.valueOf(this.ssh.hashCode()) : null).add("password", (Object)(this.password != null ? "xxxxxx" : null)).add("privateKeyFile", (Object)this.privateKeyFile).add("privateKey", (Object)(this.privateKeyData != null ? "xxxxxx" : null)).add("connectTimeout", this.connectTimeout).add("sessionTimeout", this.sessionTimeout).toString();
    }

    public static class Builder {
        protected HostAndPort hostAndPort;
        protected String username;
        protected String password;
        protected String privateKeyPassphrase;
        protected String privateKeyData;
        protected File privateKeyFile;
        protected long connectTimeout;
        protected long sessionTimeout;
        protected boolean strictHostKeyChecking;

        public Builder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String val) {
            this.password = val;
            return this;
        }

        @Deprecated
        public Builder privateKey(String val) {
            this.privateKeyData = val;
            return this;
        }

        public Builder privateKeyPassphrase(String val) {
            this.privateKeyPassphrase = val;
            return this;
        }

        public Builder privateKeyData(String val) {
            this.privateKeyData = val;
            return this;
        }

        public Builder privateKeyFile(File val) {
            this.privateKeyFile = val;
            return this;
        }

        public Builder strictHostKeyChecking(boolean val) {
            this.strictHostKeyChecking = val;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder sessionTimeout(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public SshjClientConnection build() {
            return new SshjClientConnection(this);
        }

        protected static Builder fromSSHClientConnection(SshjClientConnection in) {
            return new Builder().hostAndPort(in.getHostAndPort()).connectTimeout(in.getConnectTimeout()).sessionTimeout(in.getSessionTimeout()).username(in.username).password(in.password).privateKey(in.privateKeyData).privateKeyFile(in.privateKeyFile);
        }
    }
}

