/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.connection.ConnectionException;
import org.slf4j.Logger;

public abstract class Window {
    protected final Logger log;
    protected final Object lock = new Object();
    protected final int maxPacketSize;
    protected long size;

    public Window(long initialWinSize, int maxPacketSize, LoggerFactory loggerFactory) {
        this.size = initialWinSize;
        this.maxPacketSize = maxPacketSize;
        this.log = loggerFactory.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(long inc) {
        Object object = this.lock;
        synchronized (object) {
            this.size += inc;
            this.log.debug("Increasing by {} up to {}", (Object)inc, (Object)this.size);
            this.lock.notifyAll();
        }
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(long dec) throws ConnectionException {
        Object object = this.lock;
        synchronized (object) {
            this.size -= dec;
            this.log.debug("Consuming by {} down to {}", (Object)dec, (Object)this.size);
            if (this.size < 0L) {
                throw new ConnectionException("Window consumed to below 0");
            }
        }
    }

    public String toString() {
        return "[winSize=" + this.size + "]";
    }

    public static final class Local
    extends Window {
        private final long initialSize;
        private final long threshold;

        public Local(long initialWinSize, int maxPacketSize, LoggerFactory loggerFactory) {
            super(initialWinSize, maxPacketSize, loggerFactory);
            this.initialSize = initialWinSize;
            this.threshold = Math.min((long)(maxPacketSize * 20), this.initialSize / 4L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long neededAdjustment() {
            Object object = this.lock;
            synchronized (object) {
                return this.size <= this.threshold ? this.initialSize - this.size : 0L;
            }
        }
    }

    public static final class Remote
    extends Window {
        public Remote(long initialWinSize, int maxPacketSize, LoggerFactory loggerFactory) {
            super(initialWinSize, maxPacketSize, loggerFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long awaitExpansion(long was) throws ConnectionException {
            Object object = this.lock;
            synchronized (object) {
                while (this.size <= was) {
                    this.log.debug("Waiting, need size to grow from {} bytes", (Object)was);
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new ConnectionException(ie);
                    }
                }
                return this.size;
            }
        }

        @Override
        public void consume(long howMuch) {
            try {
                super.consume(howMuch);
            }
            catch (ConnectionException e) {
                throw new SSHRuntimeException(e);
            }
        }
    }
}

