/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.config;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.util.os.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BrooklynDevelopmentModes {
    private static final Logger log = LoggerFactory.getLogger(BrooklynDevelopmentModes.class);
    public static final ConfigKey<BrooklynDevelopmentMode> BROOKLYN_DEV_MODE = new BasicConfigKey(BrooklynDevelopmentMode.class, "brooklyn.developmentMode", "whether to run in development mode (default is to autodetect based on classpath)", (Object)BrooklynDevelopmentMode.AUTO);
    private static AtomicBoolean loggedMode = new AtomicBoolean(false);
    private static Boolean developmentMode = null;
    private static final String segment = "/core/target/classes";

    public static boolean getAutodectectedDevelopmentMode() {
        if (developmentMode != null) {
            return developmentMode;
        }
        developmentMode = BrooklynDevelopmentModes.computeAutodectectedDevelopmentMode();
        return developmentMode;
    }

    private static boolean computeAutodectectedDevelopmentMode() {
        String cp = System.getProperty("java.class.path");
        String platformSegment = Os.nativePath((String)segment);
        if (cp == null) {
            return false;
        }
        if (cp.endsWith(platformSegment) || cp.contains(platformSegment + File.pathSeparator)) {
            log.debug("Brooklyn developmentMode autodetected (based on presence of '/core/target/classes' in classpath)");
            return true;
        }
        return false;
    }

    public static enum BrooklynDevelopmentMode {
        TRUE(true),
        FALSE(false),
        AUTO(null);

        private final Boolean enabled;

        private BrooklynDevelopmentMode(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            boolean enabled = this.computeEnabled();
            if (!loggedMode.getAndSet(true)) {
                String reason;
                String string = reason = this.enabled == null ? "autodetected" : "forced";
                if (enabled) {
                    log.info("Brooklyn running in development mode (" + reason + ")");
                } else {
                    log.debug("Brooklyn not running in development mode (" + reason + ")");
                }
            }
            return enabled;
        }

        protected boolean computeEnabled() {
            if (this.enabled != null) {
                return this.enabled;
            }
            return BrooklynDevelopmentModes.getAutodectectedDevelopmentMode();
        }
    }
}

