/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Chars;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.filters.ConnectionCloseHeader;
import org.jclouds.http.filters.StripExpectHeader;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.http.utils.QueryValue;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.Binder;
import org.jclouds.rest.InputParamValidator;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.OverrideRequestFilters;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PartParam;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindMapToStringPayload;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.GetAcceptHeaders;
import org.jclouds.util.Strings2;

public class RestAnnotationProcessor
implements Function<Invocation, HttpRequest> {
    @Resource
    protected Logger logger = Logger.NULL;
    private static final Function<? super Map.Entry<String, Object>, ? extends Part> ENTRY_TO_PART = new Function<Map.Entry<String, Object>, Part>(){

        public Part apply(Map.Entry<String, Object> from) {
            return Part.create(from.getKey(), from.getValue().toString());
        }
    };
    private final Injector injector;
    private final HttpUtils utils;
    private final ContentMetadataCodec contentMetadataCodec;
    private final Supplier<Credentials> credentials;
    private final String apiVersion;
    private final String buildVersion;
    private final InputParamValidator inputParamValidator;
    private final GetAcceptHeaders getAcceptHeaders;
    private final Invocation caller;
    private final boolean stripExpectHeader;
    private final boolean connectionCloseHeader;
    private static final TypeLiteral<Supplier<URI>> uriSupplierLiteral = new TypeLiteral<Supplier<URI>>(){};
    private static final LoadingCache<Invokable<?, ?>, Set<Integer>> invokableToIndexesOfOptions = CacheBuilder.newBuilder().build(new CacheLoader<Invokable<?, ?>, Set<Integer>>(){

        public Set<Integer> load(Invokable<?, ?> invokable) {
            ImmutableSet.Builder toReturn = ImmutableSet.builder();
            for (Parameter param : Reflection2.getInvokableParameters(invokable)) {
                Class type = param.getType().getRawType();
                if (!HttpRequestOptions.class.isAssignableFrom(type) && !HttpRequestOptions[].class.isAssignableFrom(type)) continue;
                toReturn.add((Object)param.hashCode());
            }
            return toReturn.build();
        }
    });

    @Inject
    private RestAnnotationProcessor(Injector injector, @Provider Supplier<Credentials> credentials, @ApiVersion String apiVersion, @BuildVersion String buildVersion, HttpUtils utils, ContentMetadataCodec contentMetadataCodec, InputParamValidator inputParamValidator, GetAcceptHeaders getAcceptHeaders, @Nullable @Named(value="caller") Invocation caller, @Named(value="jclouds.strip-expect-header") boolean stripExpectHeader, @Named(value="jclouds.connection-close-header") boolean connectionCloseHeader) {
        this.injector = injector;
        this.utils = utils;
        this.contentMetadataCodec = contentMetadataCodec;
        this.credentials = credentials;
        this.apiVersion = apiVersion;
        this.buildVersion = buildVersion;
        this.inputParamValidator = inputParamValidator;
        this.getAcceptHeaders = getAcceptHeaders;
        this.caller = caller;
        this.stripExpectHeader = stripExpectHeader;
        this.connectionCloseHeader = connectionCloseHeader;
    }

    @Deprecated
    public GeneratedHttpRequest createRequest(Invokable<?, ?> invokable, List<Object> args) {
        return this.apply(Invocation.create(invokable, args));
    }

    public GeneratedHttpRequest apply(Invocation invocation) {
        LinkedList parts;
        Multimap<String, String> headers;
        Multimap<String, Object> formParams;
        boolean encodeFullPath;
        Preconditions.checkNotNull((Object)invocation, (Object)"invocation");
        this.inputParamValidator.validateMethodParametersOrThrow(invocation, Reflection2.getInvokableParameters(invocation.getInvokable()));
        Optional<URI> endpoint = Optional.absent();
        HttpRequest r = RestAnnotationProcessor.findOrNull(invocation.getArgs(), HttpRequest.class);
        if (r != null) {
            endpoint = Optional.fromNullable((Object)r.getEndpoint());
            if (endpoint.isPresent()) {
                this.logger.trace("using endpoint %s from invocation.getArgs() for %s", endpoint, invocation);
            }
        } else {
            endpoint = this.getEndpointFor(invocation);
            if (!endpoint.isPresent()) {
                if (this.caller != null) {
                    endpoint = this.getEndpointFor(this.caller);
                    if (endpoint.isPresent()) {
                        this.logger.trace("using endpoint %s from caller %s for %s", endpoint, this.caller, invocation);
                    } else {
                        endpoint = this.findEndpoint(invocation);
                    }
                } else {
                    endpoint = this.findEndpoint(invocation);
                }
            }
        }
        if (!endpoint.isPresent()) {
            throw new NoSuchElementException(String.format("no endpoint found for %s", invocation));
        }
        GeneratedHttpRequest.Builder requestBuilder = GeneratedHttpRequest.builder().invocation(invocation).caller(this.caller);
        String requestMethod = null;
        if (r != null) {
            requestMethod = r.getMethod();
            requestBuilder.fromHttpRequest(r);
        } else {
            requestMethod = (String)HttpUtils.tryFindHttpMethod(invocation.getInvokable()).get();
            requestBuilder.method(requestMethod);
        }
        requestBuilder.filters(this.getFiltersIfAnnotated(invocation));
        if (this.stripExpectHeader) {
            requestBuilder.filter(new StripExpectHeader());
        }
        if (this.connectionCloseHeader) {
            requestBuilder.filter(new ConnectionCloseHeader());
        }
        LinkedHashMultimap tokenValues = LinkedHashMultimap.create();
        tokenValues.put((Object)"jclouds.identity", (Object)((Credentials)this.credentials.get()).identity);
        tokenValues.put((Object)"jclouds.api-version", (Object)this.apiVersion);
        tokenValues.put((Object)"jclouds.build-version", (Object)this.buildVersion);
        Uris.UriBuilder uriBuilder = Uris.uriBuilder(((URI)endpoint.get()).toString());
        this.overridePathEncoding(uriBuilder, invocation);
        boolean bl = encodeFullPath = !this.isEncodedUsed(invocation);
        if (this.caller != null) {
            tokenValues.putAll(this.addPathAndGetTokens(this.caller, uriBuilder, encodeFullPath));
        }
        tokenValues.putAll(this.addPathAndGetTokens(invocation, uriBuilder, encodeFullPath));
        if (this.caller != null) {
            formParams = this.addFormParams((Multimap<String, ?>)tokenValues, this.caller);
            formParams.putAll(this.addFormParams((Multimap<String, ?>)tokenValues, invocation));
        } else {
            formParams = this.addFormParams((Multimap<String, ?>)tokenValues, invocation);
        }
        Multimap<String, Object> queryParams = this.addQueryParams((Multimap<String, ?>)tokenValues, invocation);
        if (this.caller != null) {
            headers = this.buildHeaders((Multimap<String, ?>)tokenValues, this.caller);
            headers.putAll(this.buildHeaders((Multimap<String, ?>)tokenValues, invocation));
        } else {
            headers = this.buildHeaders((Multimap<String, ?>)tokenValues, invocation);
        }
        if (r != null) {
            headers.putAll(r.getHeaders());
        }
        if (this.shouldAddHostHeader(invocation)) {
            StringBuilder hostHeader = new StringBuilder(((URI)endpoint.get()).getHost());
            if (((URI)endpoint.get()).getPort() != -1) {
                hostHeader.append(":").append(((URI)endpoint.get()).getPort());
            }
            headers.put((Object)"Host", (Object)hostHeader.toString());
        }
        org.jclouds.io.Payload payload = null;
        for (HttpRequestOptions options : this.findOptionsIn(invocation)) {
            String stringPayload;
            this.injector.injectMembers((Object)options);
            for (Map.Entry header : options.buildRequestHeaders().entries()) {
                headers.put(header.getKey(), (Object)Strings2.replaceTokens((String)header.getValue(), tokenValues));
            }
            for (Map.Entry query : options.buildQueryParameters().entries()) {
                queryParams.put((Object)Strings2.urlEncode((String)query.getKey(), '/', ','), (Object)new QueryValue(Strings2.replaceTokens((String)query.getValue(), tokenValues), false));
            }
            for (Map.Entry form : options.buildFormParameters().entries()) {
                formParams.put(form.getKey(), (Object)Strings2.replaceTokens((String)form.getValue(), tokenValues));
            }
            String pathSuffix = options.buildPathSuffix();
            if (pathSuffix != null) {
                uriBuilder.appendPath(pathSuffix);
            }
            if ((stringPayload = options.buildStringPayload()) == null) continue;
            payload = Payloads.newStringPayload(stringPayload);
        }
        if (!queryParams.isEmpty()) {
            uriBuilder.query(queryParams);
        }
        requestBuilder.headers(HttpUtils.filterOutContentHeaders(headers));
        requestBuilder.endpoint(uriBuilder.build(RestAnnotationProcessor.convertUnsafe(tokenValues), encodeFullPath));
        if (payload == null) {
            PayloadEnclosing payloadEnclosing = RestAnnotationProcessor.findOrNull(invocation.getArgs(), PayloadEnclosing.class);
            org.jclouds.io.Payload payload2 = payload = payloadEnclosing != null ? payloadEnclosing.getPayload() : RestAnnotationProcessor.findOrNull(invocation.getArgs(), org.jclouds.io.Payload.class);
        }
        if (!(parts = RestAnnotationProcessor.getParts(invocation, ImmutableMultimap.builder().putAll((Multimap)tokenValues).putAll(formParams).build())).isEmpty()) {
            if (!formParams.isEmpty()) {
                parts = Lists.newLinkedList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)formParams.entries(), ENTRY_TO_PART), parts));
            }
            payload = new MultipartForm("--JCLOUDS--", parts);
        } else if (!formParams.isEmpty()) {
            payload = Payloads.newUrlEncodedFormPayload((Multimap<String, String>)Multimaps.transformValues(formParams, (Function)NullableToStringFunction.INSTANCE));
        } else if (headers.containsKey((Object)"Content-Type") && !HttpRequest.NON_PAYLOAD_METHODS.contains(requestMethod)) {
            if (payload == null) {
                payload = Payloads.newByteArrayPayload(new byte[0]);
            }
            payload.getContentMetadata().setContentType((String)Iterables.get((Iterable)headers.get((Object)"Content-Type"), (int)0));
        }
        if (payload != null) {
            requestBuilder.payload(payload);
        }
        GeneratedHttpRequest request = requestBuilder.build();
        MapBinder mapBinder = this.getMapPayloadBinderOrNull(invocation);
        if (mapBinder != null) {
            Map<String, Object> mapParams;
            if (this.caller != null) {
                mapParams = this.buildPayloadParams(this.caller);
                mapParams.putAll(this.buildPayloadParams(invocation));
            } else {
                mapParams = this.buildPayloadParams(invocation);
            }
            if (invocation.getInvokable().isAnnotationPresent(PayloadParams.class)) {
                PayloadParams params = (PayloadParams)invocation.getInvokable().getAnnotation(PayloadParams.class);
                this.addMapPayload(mapParams, params, headers, (Multimap<String, Object>)tokenValues);
            }
            request = mapBinder.bindToRequest(request, mapParams);
        } else {
            request = this.decorateRequest(request);
        }
        if (request.getPayload() != null) {
            this.contentMetadataCodec.fromHeaders(request.getPayload().getContentMetadata(), headers);
        }
        request = RestAnnotationProcessor.stripExpectHeaderIfContentZero(request);
        this.utils.checkRequestHasRequiredProperties(request);
        return request;
    }

    private static <T> T findOrNull(Iterable<Object> args, Class<T> clazz) {
        return clazz.cast(Iterables.tryFind(args, (Predicate)Predicates.instanceOf(clazz)).orNull());
    }

    private static <K, V> Map<K, V> convertUnsafe(Multimap<K, V> in) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        for (Map.Entry entry : in.entries()) {
            out.put(entry.getKey(), entry.getValue());
        }
        return ImmutableMap.copyOf((Map)out);
    }

    private void overridePathEncoding(Uris.UriBuilder uriBuilder, Invocation invocation) {
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(SkipEncoding.class)) {
            uriBuilder.skipPathEncoding(Chars.asList((char[])invocation.getInvokable().getOwnerType().getRawType().getAnnotation(SkipEncoding.class).value()));
        }
        if (invocation.getInvokable().isAnnotationPresent(SkipEncoding.class)) {
            uriBuilder.skipPathEncoding(Chars.asList((char[])((SkipEncoding)invocation.getInvokable().getAnnotation(SkipEncoding.class)).value()));
        }
    }

    protected Optional<URI> findEndpoint(Invocation invocation) {
        Optional endpoint = this.getEndpointFor(invocation);
        if (endpoint.isPresent()) {
            this.logger.trace("using endpoint %s for %s", endpoint, invocation);
        }
        if (!endpoint.isPresent()) {
            this.logger.trace("looking up default endpoint for %s", invocation);
            endpoint = Optional.fromNullable((Object)((Supplier)this.injector.getInstance(Key.get(uriSupplierLiteral, Provider.class))).get());
            if (endpoint.isPresent()) {
                this.logger.trace("using default endpoint %s for %s", endpoint, invocation);
            }
        }
        return endpoint;
    }

    private Multimap<String, Object> addPathAndGetTokens(Invocation invocation, Uris.UriBuilder uriBuilder, boolean encodeFullPath) {
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Path.class)) {
            uriBuilder.appendPath(invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Path.class).value());
        }
        if (invocation.getInvokable().isAnnotationPresent(Path.class)) {
            uriBuilder.appendPath(((Path)invocation.getInvokable().getAnnotation(Path.class)).value());
        }
        return this.getPathParamKeyValues(invocation, encodeFullPath);
    }

    private Multimap<String, Object> addFormParams(Multimap<String, ?> tokenValues, Invocation invocation) {
        FormParams form;
        LinkedListMultimap formMap = LinkedListMultimap.create();
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(FormParams.class)) {
            form = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(FormParams.class);
            this.addForm((Multimap<String, Object>)formMap, form, tokenValues);
        }
        if (invocation.getInvokable().isAnnotationPresent(FormParams.class)) {
            form = (FormParams)invocation.getInvokable().getAnnotation(FormParams.class);
            this.addForm((Multimap<String, Object>)formMap, form, tokenValues);
        }
        for (Map.Entry form2 : this.getFormParamKeyValues(invocation).entries()) {
            formMap.put(form2.getKey(), (Object)Strings2.replaceTokens(form2.getValue().toString(), tokenValues));
        }
        return formMap;
    }

    private Multimap<String, Object> addQueryParams(Multimap<String, ?> tokenValues, Invocation invocation) {
        QueryParams query;
        LinkedListMultimap queryMap = LinkedListMultimap.create();
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(QueryParams.class)) {
            query = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(QueryParams.class);
            this.addQuery((Multimap<String, Object>)queryMap, query, tokenValues);
        }
        if (invocation.getInvokable().isAnnotationPresent(QueryParams.class)) {
            query = (QueryParams)invocation.getInvokable().getAnnotation(QueryParams.class);
            this.addQuery((Multimap<String, Object>)queryMap, query, tokenValues);
        }
        for (Map.Entry query2 : this.getQueryParamKeyValues(invocation, tokenValues).entries()) {
            queryMap.put(query2.getKey(), query2.getValue());
        }
        return queryMap;
    }

    private void addForm(Multimap<String, Object> formParams, FormParams form, Multimap<String, ?> tokenValues) {
        for (int i = 0; i < form.keys().length; ++i) {
            if (form.values()[i].equals("FORM_NULL")) {
                formParams.removeAll((Object)form.keys()[i]);
                formParams.put((Object)form.keys()[i], null);
                continue;
            }
            formParams.put((Object)form.keys()[i], (Object)Strings2.replaceTokens(form.values()[i], tokenValues));
        }
    }

    private void addQuery(Multimap<String, Object> queryParams, QueryParams query, Multimap<String, ?> tokenValues) {
        for (int i = 0; i < query.keys().length; ++i) {
            String key = Strings2.urlEncode(query.keys()[i], '/', ',');
            if (query.values()[i].equals("QUERY_NULL")) {
                queryParams.removeAll((Object)key);
                queryParams.put((Object)key, null);
                continue;
            }
            queryParams.put((Object)key, (Object)new QueryValue(Strings2.replaceTokens(query.values()[i], tokenValues), false));
        }
    }

    private void addMapPayload(Map<String, Object> postParams, PayloadParams mapDefaults, Multimap<String, String> headers, Multimap<String, Object> tokenValues) {
        for (int i = 0; i < mapDefaults.keys().length; ++i) {
            if (mapDefaults.values()[i].equals("MAP_PAYLOAD_NULL")) {
                postParams.put(mapDefaults.keys()[i], null);
                continue;
            }
            postParams.put(mapDefaults.keys()[i], Strings2.replaceTokens(Strings2.replaceTokens(mapDefaults.values()[i], headers), tokenValues));
        }
    }

    private List<HttpRequestFilter> getFiltersIfAnnotated(Invocation invocation) {
        HttpRequestFilter instance;
        ArrayList filters = Lists.newArrayList();
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(RequestFilters.class)) {
            for (Class<? extends HttpRequestFilter> clazz : invocation.getInvokable().getOwnerType().getRawType().getAnnotation(RequestFilters.class).value()) {
                instance = (HttpRequestFilter)this.injector.getInstance(clazz);
                filters.add(instance);
                this.logger.trace("adding filter %s from annotation on %s", instance, invocation.getInvokable().getOwnerType().getRawType().getName());
            }
        }
        if (invocation.getInvokable().isAnnotationPresent(RequestFilters.class)) {
            if (invocation.getInvokable().isAnnotationPresent(OverrideRequestFilters.class)) {
                filters.clear();
            }
            for (Class<? extends HttpRequestFilter> clazz : ((RequestFilters)invocation.getInvokable().getAnnotation(RequestFilters.class)).value()) {
                instance = (HttpRequestFilter)this.injector.getInstance(clazz);
                filters.add(instance);
                this.logger.trace("adding filter %s from annotation on %s", instance, invocation.getInvokable().getName());
            }
        }
        return filters;
    }

    @VisibleForTesting
    static URI getEndpointInParametersOrNull(Invocation invocation, Injector injector) {
        Collection<Parameter> endpointParams = RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), EndpointParam.class);
        if (endpointParams.isEmpty()) {
            return null;
        }
        Preconditions.checkState((endpointParams.size() == 1 ? 1 : 0) != 0, (String)"invocation.getInvoked() %s has too many EndpointParam annotations", (Object[])new Object[]{invocation.getInvokable()});
        Parameter endpointParam = (Parameter)Iterables.get(endpointParams, (int)0);
        Function parser = (Function)injector.getInstance(((EndpointParam)endpointParam.getAnnotation(EndpointParam.class)).parser());
        int position = endpointParam.hashCode();
        try {
            URI returnVal = (URI)parser.apply(invocation.getArgs().get(position));
            Preconditions.checkArgument((returnVal != null ? 1 : 0) != 0, (String)"endpoint for [%s] not configured for %s", (Object[])new Object[]{position, invocation.getInvokable()});
            return returnVal;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(String.format("argument at index %d on invocation.getInvoked() %s was null", position, invocation.getInvokable()), e);
        }
    }

    private static Collection<Parameter> parametersWithAnnotation(Invokable<?, ?> invokable, final Class<? extends Annotation> annotationType) {
        return Collections2.filter(Reflection2.getInvokableParameters(invokable), (Predicate)new Predicate<Parameter>(){

            public boolean apply(Parameter in) {
                return in.isAnnotationPresent(annotationType);
            }
        });
    }

    protected Optional<URI> getEndpointFor(Invocation invocation) {
        URI endpoint = RestAnnotationProcessor.getEndpointInParametersOrNull(invocation, this.injector);
        if (endpoint == null) {
            Endpoint annotation;
            if (invocation.getInvokable().isAnnotationPresent(Endpoint.class)) {
                annotation = (Endpoint)invocation.getInvokable().getAnnotation(Endpoint.class);
            } else if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Endpoint.class)) {
                annotation = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Endpoint.class);
            } else {
                this.logger.trace("no annotations on class or invocation.getInvoked(): %s", invocation.getInvokable());
                return Optional.absent();
            }
            endpoint = (URI)((Supplier)this.injector.getInstance(Key.get(uriSupplierLiteral, annotation.value()))).get();
        }
        URI provider = (URI)((Supplier)this.injector.getInstance(Key.get(uriSupplierLiteral, Provider.class))).get();
        return Optional.fromNullable((Object)RestAnnotationProcessor.addHostIfMissing(endpoint, provider));
    }

    @VisibleForTesting
    static URI addHostIfMissing(URI original, URI withHost) {
        Preconditions.checkNotNull((Object)withHost, (Object)"URI withHost cannot be null");
        Preconditions.checkArgument((withHost.getHost() != null ? 1 : 0) != 0, (Object)("URI withHost must have host:" + withHost));
        if (original == null) {
            return null;
        }
        if (original.getHost() != null) {
            return original;
        }
        String host = withHost.toString();
        URI baseURI = host.endsWith("/") ? withHost : URI.create(host + "/");
        return baseURI.resolve(original);
    }

    private MapBinder getMapPayloadBinderOrNull(Invocation invocation) {
        if (invocation.getArgs() != null) {
            for (Object arg : invocation.getArgs()) {
                if (arg instanceof Object[]) {
                    Object[] postBinders = (Object[])arg;
                    if (postBinders.length == 0) continue;
                    if (postBinders.length == 1) {
                        if (!(postBinders[0] instanceof MapBinder)) continue;
                        MapBinder binder = (MapBinder)postBinders[0];
                        this.injector.injectMembers((Object)binder);
                        return binder;
                    }
                    if (!(postBinders[0] instanceof MapBinder)) continue;
                    throw new IllegalArgumentException("we currently do not support multiple varinvocation.getArgs() postBinders in: " + invocation.getInvokable().getName());
                }
                if (!(arg instanceof MapBinder)) continue;
                MapBinder binder = (MapBinder)arg;
                this.injector.injectMembers((Object)binder);
                return binder;
            }
        }
        if (invocation.getInvokable().isAnnotationPresent(org.jclouds.rest.annotations.MapBinder.class)) {
            return (MapBinder)this.injector.getInstance(((org.jclouds.rest.annotations.MapBinder)invocation.getInvokable().getAnnotation(org.jclouds.rest.annotations.MapBinder.class)).value());
        }
        if (invocation.getInvokable().isAnnotationPresent(Payload.class)) {
            return (MapBinder)this.injector.getInstance(BindMapToStringPayload.class);
        }
        if (invocation.getInvokable().isAnnotationPresent(WrapWith.class)) {
            return ((BindToJsonPayloadWrappedWith.Factory)this.injector.getInstance(BindToJsonPayloadWrappedWith.Factory.class)).create(((WrapWith)invocation.getInvokable().getAnnotation(WrapWith.class)).value());
        }
        return null;
    }

    private boolean shouldAddHostHeader(Invocation invocation) {
        return invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(VirtualHost.class) || invocation.getInvokable().isAnnotationPresent(VirtualHost.class);
    }

    private GeneratedHttpRequest decorateRequest(GeneratedHttpRequest request) throws NegativeArraySizeException {
        Invocation invocation = request.getInvocation();
        List<Object> args = request.getInvocation().getArgs();
        ImmutableSet binderOrWrapWith = ImmutableSet.copyOf((Iterable)Iterables.concat(RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), BinderParam.class), RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), WrapWith.class)));
        for (Parameter entry : binderOrWrapWith) {
            Object[] arg;
            int position = entry.hashCode();
            boolean shouldBreak = false;
            Binder binder = entry.isAnnotationPresent(BinderParam.class) ? (Binder)this.injector.getInstance(((BinderParam)entry.getAnnotation(BinderParam.class)).value()) : ((BindToJsonPayloadWrappedWith.Factory)this.injector.getInstance(BindToJsonPayloadWrappedWith.Factory.class)).create(((WrapWith)entry.getAnnotation(WrapWith.class)).value());
            Object[] objectArray = arg = args.size() >= position + 1 ? args.get(position) : null;
            if (args.size() >= position + 1 && arg != null) {
                Class parameterType = entry.getType().getRawType();
                Class<?> argType = arg.getClass();
                if (!argType.isArray() && parameterType.isArray()) {
                    int arrayLength = args.size() - Reflection2.getInvokableParameters(invocation.getInvokable()).size() + 1;
                    if (arrayLength == 0) break;
                    arg = (Object[])Array.newInstance(arg.getClass(), arrayLength);
                    System.arraycopy(args.toArray(), position, arg, 0, arrayLength);
                    shouldBreak = true;
                } else if (!(argType.isArray() && parameterType.isArray() || !arg.getClass().isArray())) {
                    Object[] payloadArray = arg;
                    Object[] objectArray2 = arg = payloadArray.length > 0 ? payloadArray[0] : null;
                }
                if (arg != null) {
                    request = binder.bindToRequest(request, arg);
                }
                if (!shouldBreak) continue;
                break;
            }
            if (position + 1 == Reflection2.getInvokableParameters(invocation.getInvokable()).size() && entry.getType().isArray() || entry.isAnnotationPresent(Nullable.class)) continue;
            Preconditions.checkNotNull((Object)arg, (Object)(invocation.getInvokable().getName() + " parameter " + (position + 1)));
        }
        return request;
    }

    private Set<HttpRequestOptions> findOptionsIn(Invocation invocation) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Iterator iterator = ((Set)invokableToIndexesOfOptions.getUnchecked(invocation.getInvokable())).iterator();
        while (iterator.hasNext()) {
            int index;
            if (invocation.getArgs().size() < index + 1) continue;
            if (invocation.getArgs().get(index) instanceof Object[]) {
                for (Object option : (Object[])invocation.getArgs().get(index)) {
                    if (!(option instanceof HttpRequestOptions)) continue;
                    result.add((Object)((HttpRequestOptions)option));
                }
                continue;
            }
            for (index = ((Integer)iterator.next()).intValue(); index < invocation.getArgs().size(); ++index) {
                if (!(invocation.getArgs().get(index) instanceof HttpRequestOptions)) continue;
                result.add((Object)((HttpRequestOptions)invocation.getArgs().get(index)));
            }
        }
        return result.build();
    }

    private Multimap<String, String> buildHeaders(Multimap<String, ?> tokenValues, Invocation invocation) {
        LinkedHashMultimap headers = LinkedHashMultimap.create();
        this.addHeaderIfAnnotationPresentOnMethod((Multimap<String, String>)headers, invocation, tokenValues);
        for (Parameter headerParam : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), HeaderParam.class)) {
            Annotation key = headerParam.getAnnotation(HeaderParam.class);
            String value = invocation.getArgs().get(headerParam.hashCode()).toString();
            value = Strings2.replaceTokens(value, tokenValues);
            headers.put((Object)((HeaderParam)key).value(), (Object)value);
        }
        this.addProducesIfPresentOnTypeOrMethod((Multimap<String, String>)headers, invocation);
        this.addConsumesIfPresentOnTypeOrMethod((Multimap<String, String>)headers, invocation);
        return headers;
    }

    private void addConsumesIfPresentOnTypeOrMethod(Multimap<String, String> headers, Invocation invocation) {
        Set<String> accept = this.getAcceptHeaders.apply(invocation);
        if (!accept.isEmpty()) {
            headers.replaceValues((Object)"Accept", accept);
        }
    }

    private void addProducesIfPresentOnTypeOrMethod(Multimap<String, String> headers, Invocation invocation) {
        Produces header;
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Produces.class)) {
            header = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Produces.class);
            headers.replaceValues((Object)"Content-Type", Arrays.asList(header.value()));
        }
        if (invocation.getInvokable().isAnnotationPresent(Produces.class)) {
            header = (Produces)invocation.getInvokable().getAnnotation(Produces.class);
            headers.replaceValues((Object)"Content-Type", Arrays.asList(header.value()));
        }
    }

    private void addHeaderIfAnnotationPresentOnMethod(Multimap<String, String> headers, Invocation invocation, Multimap<String, ?> tokenValues) {
        Headers header;
        if (invocation.getInvokable().getOwnerType().getRawType().isAnnotationPresent(Headers.class)) {
            header = invocation.getInvokable().getOwnerType().getRawType().getAnnotation(Headers.class);
            RestAnnotationProcessor.addHeader(headers, header, tokenValues);
        }
        if (invocation.getInvokable().isAnnotationPresent(Headers.class)) {
            header = (Headers)invocation.getInvokable().getAnnotation(Headers.class);
            RestAnnotationProcessor.addHeader(headers, header, tokenValues);
        }
    }

    private static void addHeader(Multimap<String, String> headers, Headers header, Multimap<String, ?> tokenValues) {
        for (int i = 0; i < header.keys().length; ++i) {
            String value = header.values()[i];
            value = Strings2.replaceTokens(value, tokenValues);
            if (i < header.urlEncode().length && header.urlEncode()[i]) {
                value = Strings2.urlEncode(value, '/');
            }
            headers.put((Object)header.keys()[i], (Object)value);
        }
    }

    private static List<Part> getParts(Invocation invocation, Multimap<String, ?> tokenValues) {
        ImmutableList.Builder parts = ImmutableList.builder();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), PartParam.class)) {
            PartParam partParam = (PartParam)param.getAnnotation(PartParam.class);
            Part.PartOptions options = new Part.PartOptions();
            if (!"---NO_CONTENT_TYPE---".equals(partParam.contentType())) {
                options.contentType(partParam.contentType());
            }
            if (!"---NO_FILENAME---".equals(partParam.filename())) {
                options.filename(Strings2.replaceTokens(partParam.filename(), tokenValues));
            }
            Object arg = invocation.getArgs().get(param.hashCode());
            Preconditions.checkNotNull((Object)arg, (Object)partParam.name());
            Part part = Part.create(partParam.name(), Payloads.newPayload(arg), options);
            parts.add((Object)part);
        }
        return parts.build();
    }

    private static GeneratedHttpRequest stripExpectHeaderIfContentZero(GeneratedHttpRequest request) {
        boolean isBodyEmpty = true;
        if (request.getPayload() != null) {
            Long length = request.getPayload().getContentMetadata().getContentLength();
            boolean bl = isBodyEmpty = length != null && length == 0L;
        }
        if (isBodyEmpty) {
            request = ((GeneratedHttpRequest.Builder)request.toBuilder().removeHeader("Expect")).build();
        }
        return request;
    }

    private boolean isEncodedUsed(Invocation invocation) {
        return !RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), Encoded.class).isEmpty();
    }

    private Multimap<String, Object> getPathParamKeyValues(Invocation invocation, boolean encodeFullPath) {
        LinkedHashMultimap pathParamValues = LinkedHashMultimap.create();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), PathParam.class)) {
            PathParam pathParam = (PathParam)param.getAnnotation(PathParam.class);
            String paramKey = pathParam.value();
            Optional<?> paramValue = this.getParamValue(invocation, (ParamParser)param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            if (!paramValue.isPresent()) continue;
            if (!encodeFullPath && !param.isAnnotationPresent(Encoded.class)) {
                pathParamValues.put((Object)paramKey, (Object)Strings2.urlEncode(paramValue.get().toString(), new char[0]));
                continue;
            }
            pathParamValues.put((Object)paramKey, (Object)paramValue.get().toString());
        }
        return pathParamValues;
    }

    private Optional<?> getParamValue(Invocation invocation, @Nullable ParamParser extractor, int argIndex, String paramKey) {
        Object arg = invocation.getArgs().get(argIndex);
        if (extractor != null && this.checkPresentOrNullable(invocation, paramKey, argIndex, arg)) {
            arg = ((Function)this.injector.getInstance(extractor.value())).apply(arg);
        }
        this.checkPresentOrNullable(invocation, paramKey, argIndex, arg);
        return Optional.fromNullable((Object)arg);
    }

    private boolean checkPresentOrNullable(Invocation invocation, String paramKey, int argIndex, Object arg) {
        if (arg == null && !Reflection2.getInvokableParameters(invocation.getInvokable()).get(argIndex).isAnnotationPresent(Nullable.class)) {
            throw new NullPointerException(String.format("param{%s} for invocation %s.%s", paramKey, invocation.getInvokable().getOwnerType().getRawType().getSimpleName(), invocation.getInvokable().getName()));
        }
        return true;
    }

    private Multimap<String, Object> getFormParamKeyValues(Invocation invocation) {
        LinkedHashMultimap formParamValues = LinkedHashMultimap.create();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), FormParam.class)) {
            FormParam formParam = (FormParam)param.getAnnotation(FormParam.class);
            String paramKey = formParam.value();
            Optional<?> paramValue = this.getParamValue(invocation, (ParamParser)param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            if (!paramValue.isPresent()) continue;
            formParamValues.put((Object)paramKey, (Object)paramValue.get().toString());
        }
        return formParamValues;
    }

    private Multimap<String, Object> getQueryParamKeyValues(Invocation invocation, Multimap<String, ?> tokenValues) {
        LinkedHashMultimap queryParamValues = LinkedHashMultimap.create();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), QueryParam.class)) {
            QueryParam queryParam = (QueryParam)param.getAnnotation(QueryParam.class);
            String paramKey = Strings2.urlEncode(queryParam.value(), '/', ',');
            Optional<?> paramValue = this.getParamValue(invocation, (ParamParser)param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            boolean encoded = param.isAnnotationPresent(Encoded.class);
            if (!paramValue.isPresent()) continue;
            if (paramValue.get() instanceof Iterable) {
                Iterable iterableStrings = Iterables.transform((Iterable)((Iterable)Iterable.class.cast(paramValue.get())), (Function)Functions.toStringFunction());
                ArrayList<QueryValue> values = new ArrayList<QueryValue>();
                for (String stringValue : iterableStrings) {
                    values.add(new QueryValue(Strings2.replaceTokens(stringValue, tokenValues), encoded));
                }
                queryParamValues.putAll((Object)paramKey, values);
                continue;
            }
            String value = paramValue.get().toString();
            queryParamValues.put((Object)paramKey, (Object)new QueryValue(Strings2.replaceTokens(value, tokenValues), encoded));
        }
        return queryParamValues;
    }

    private Map<String, Object> buildPayloadParams(Invocation invocation) {
        LinkedHashMap payloadParamValues = Maps.newLinkedHashMap();
        for (Parameter param : RestAnnotationProcessor.parametersWithAnnotation(invocation.getInvokable(), PayloadParam.class)) {
            PayloadParam payloadParam = (PayloadParam)param.getAnnotation(PayloadParam.class);
            String paramKey = payloadParam.value();
            Optional<?> paramValue = this.getParamValue(invocation, (ParamParser)param.getAnnotation(ParamParser.class), param.hashCode(), paramKey);
            if (!paramValue.isPresent()) continue;
            payloadParamValues.put(paramKey, paramValue.get());
        }
        return payloadParamValues;
    }

    public String toString() {
        String callerString = this.caller != null ? String.format("%s.%s%s", this.caller.getInvokable().getOwnerType().getRawType().getSimpleName(), this.caller.getInvokable().getName(), this.caller.getArgs()) : null;
        return MoreObjects.toStringHelper((String)"").omitNullValues().add("caller", callerString).toString();
    }

    private static enum NullableToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        public String apply(Object o) {
            if (o == null) {
                return null;
            }
            return o.toString();
        }
    }
}

