/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.utils.Queries;
import org.jclouds.rest.Binder;

@Singleton
public class BindAccountSecurityGroupPairsToIndexedQueryParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Multimap), (Object)"this binder is only valid for Multimaps!");
        Multimap pairs = (Multimap)Preconditions.checkNotNull((Object)input, (Object)"account group pairs");
        Preconditions.checkArgument((!pairs.isEmpty() ? 1 : 0) != 0, (Object)"you must specify at least one account, group pair");
        Multimap existingParams = (Multimap)Queries.queryParser().apply((Object)request.getEndpoint().getQuery());
        ImmutableMultimap.Builder map = ImmutableMultimap.builder().putAll(existingParams);
        int i = 0;
        for (Map.Entry entry : pairs.entries()) {
            map.put((Object)String.format("usersecuritygrouplist[%d].account", i), entry.getKey()).put((Object)String.format("usersecuritygrouplist[%d].group", i++), entry.getValue());
        }
        URI endpoint = Uris.uriBuilder((URI)request.getEndpoint()).query((Multimap)map.build()).build();
        return (R)request.toBuilder().endpoint(endpoint).build();
    }
}

