/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.test.framework.LoopOverGroupMembersTestCase;
import org.apache.brooklyn.test.framework.TargetableTestComponent;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestCase;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopOverGroupMembersTestCaseImpl
extends TargetableTestComponentImpl
implements LoopOverGroupMembersTestCase {
    private static final Logger logger = LoggerFactory.getLogger(LoopOverGroupMembersTestCaseImpl.class);

    public void start(@EffectorParam(name="locations") Collection<? extends Location> locations) {
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.STARTING);
        Maybe<Entity> target = this.tryResolveTarget();
        if (!target.isPresent()) {
            logger.debug("Tasks NOT successfully run. LoopOverGroupMembersTestCaseImpl group not set");
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            return;
        }
        if (!(target.get() instanceof Group)) {
            logger.debug("Tasks NOT successfully run. LoopOverGroupMembersTestCaseImpl target is not a group");
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            return;
        }
        EntitySpec testSpec = (EntitySpec)this.config().get(TEST_SPEC);
        if (testSpec == null) {
            logger.debug("Tasks NOT successfully run. LoopOverGroupMembersTestCaseImpl test spec not set");
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            return;
        }
        Group group = (Group)target.get();
        Collection members = group.getMembers();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        boolean allSuccesful = true;
        for (Entity member : members) {
            EntitySpec testSpecCopy = (EntitySpec)EntitySpec.create((EntitySpec)testSpec).configure((ConfigKey.HasConfigKey)TestCase.TARGET_ENTITY, (Object)member);
            try {
                TargetableTestComponent targetableTestComponent = (TargetableTestComponent)this.addChild(testSpecCopy);
                targetableTestComponent.start(locations);
                if (this.isChildRunningEventually(targetableTestComponent, Duration.FIVE_SECONDS)) {
                    logger.debug("Task of {} successfully run, targetting {}", (Object)this, (Object)member);
                    continue;
                }
                logger.warn("Problem in child test-case of {}, child {} targetting {}", new Object[]{this, targetableTestComponent, member});
                allSuccesful = false;
            }
            catch (Throwable t) {
                Exceptions.propagateIfFatal((Throwable)t);
                logger.warn("Problem in child test-case of " + this + ", targetting " + member, t);
                exceptions.add(t);
                allSuccesful = false;
            }
        }
        if (!allSuccesful) {
            logger.debug("Tasks NOT successfully run. Update state of {} to ON_FIRE.", (Object)this);
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((String)"Test failed on group member(s)", exceptions);
        }
        logger.debug("Tasks successfully run. Update state of {} to RUNNING.", (Object)this);
        this.setUpAndRunState(true, Lifecycle.RUNNING);
    }

    public void stop() {
        this.sensors().set(Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.STOPPING);
        try {
            for (Entity child : this.getChildren()) {
                if (!(child instanceof Startable)) continue;
                ((Startable)child).stop();
            }
            logger.debug("Tasks successfully run. Update state of {} to STOPPED.", (Object)this);
            this.setUpAndRunState(false, Lifecycle.STOPPED);
        }
        catch (Throwable t) {
            logger.debug("Tasks NOT successfully run. Update state of {} to ON_FIRE.", (Object)this);
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    private boolean isChildRunningEventually(Entity entity, Duration timeout) {
        Callable<Boolean> untilCondition = () -> Lifecycle.RUNNING.equals(entity.sensors().get(Attributes.SERVICE_STATE_ACTUAL)) || Lifecycle.ON_FIRE.equals(entity.sensors().get(Attributes.SERVICE_STATE_ACTUAL));
        Repeater.create((String)("is-child-running " + entity)).backoffTo(timeout.multiply(0.1)).limitTimeTo(timeout).rethrowException().until(untilCondition).run();
        return Lifecycle.RUNNING.equals(entity.sensors().get(Attributes.SERVICE_STATE_ACTUAL));
    }
}

