/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.mgmt.entitlement.EntitlementPredicates;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.EntityApi;
import org.apache.brooklyn.rest.domain.EntitySummary;
import org.apache.brooklyn.rest.domain.LocationSummary;
import org.apache.brooklyn.rest.domain.TaskSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.resources.ApplicationResource;
import org.apache.brooklyn.rest.transform.EntityTransformer;
import org.apache.brooklyn.rest.transform.LocationTransformer;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class EntityResource
extends AbstractBrooklynRestResource
implements EntityApi {
    private static final Logger log = LoggerFactory.getLogger(EntityResource.class);
    @Context
    private UriInfo uriInfo;

    public List<EntitySummary> list(String application) {
        return FluentIterable.from((Iterable)this.brooklyn().getApplication(application).getChildren()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).transform(EntityTransformer.fromEntity(this.ui.getBaseUriBuilder())).toList();
    }

    public EntitySummary get(String application, String entityName) {
        Entity entity = this.brooklyn().getEntity(application, entityName);
        if (Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            return EntityTransformer.entitySummary(entity, this.ui.getBaseUriBuilder());
        }
        throw WebResourceUtils.forbidden("User '%s' is not authorized to get entity '%s'", Entitlements.getEntitlementContext().user(), entity);
    }

    public List<EntitySummary> getChildren(String application, String entity) {
        return FluentIterable.from((Iterable)this.brooklyn().getEntity(application, entity).getChildren()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).transform(EntityTransformer.fromEntity(this.ui.getBaseUriBuilder())).toList();
    }

    public Response addChildren(String applicationToken, String entityToken, Boolean start, String timeoutS, String yaml) {
        Response.ResponseBuilder response;
        Entity parent = this.brooklyn().getEntity(applicationToken, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)parent)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entityToken);
        }
        EntityManagementUtils.CreationResult added = EntityManagementUtils.addChildren((Entity)parent, (String)yaml, (Boolean)start).blockUntilComplete(timeoutS == null ? Duration.millis((Number)20) : Duration.of((Object)timeoutS));
        if (((List)added.get()).size() == 1) {
            Entity child = (Entity)Iterables.getOnlyElement((Iterable)((Iterable)added.get()));
            URI ref = WebResourceUtils.serviceAbsoluteUriBuilder(this.uriInfo.getBaseUriBuilder(), EntityApi.class, "get").build(new Object[]{child.getApplicationId(), child.getId()});
            response = Response.created((URI)ref);
        } else {
            response = Response.status((Response.Status)Response.Status.CREATED);
        }
        return response.entity((Object)TaskTransformer.taskSummary(added.task(), this.ui.getBaseUriBuilder())).build();
    }

    public List<TaskSummary> listTasks(String applicationId, String entityId, int limit, Boolean recurse) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        return TaskTransformer.fromTasks(MutableList.copyOf((Iterable)BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.mgmt().getExecutionManager(), (Entity)entity)), limit, recurse, entity, this.ui);
    }

    @Deprecated
    public List<TaskSummary> listTasks(String applicationId, String entityId) {
        return this.listTasks(applicationId, entityId, -1, false);
    }

    public TaskSummary getTask(String application, String entityToken, String taskId) {
        Application entity = this.brooklyn().getApplication(application);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see the task '%s' for the entity '%s'", Entitlements.getEntitlementContext().user(), taskId, entity);
        }
        Task t = this.mgmt().getExecutionManager().getTask(taskId);
        if (t == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s'", taskId);
        }
        return (TaskSummary)TaskTransformer.fromTask(this.ui.getBaseUriBuilder()).apply((Object)t);
    }

    public List<Object> listTags(String applicationId, String entityId) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        return (List)this.resolving(MutableList.copyOf((Iterable)entity.tags().getTags())).preferJson(true).resolve();
    }

    public Response getIcon(String applicationId, String entityId) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        String url = RegisteredTypes.getIconUrl((BrooklynObject)entity);
        if (url == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.brooklyn().isUrlServerSideAndSafe(url)) {
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            InputStream content = ResourceUtils.create((Object)entity).getResourceFromUrl(url);
            return Response.ok((Object)content, (MediaType)mime).build();
        }
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }

    public Response rename(String application, String entity, String newName) {
        Entity instance = this.brooklyn().getEntity(application, entity);
        if (instance != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.RENAME_ENTITY, (Object)instance)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to rename the entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        instance.setDisplayName(newName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public Response expunge(String application, String entity, boolean release) {
        Entity instance = this.brooklyn().getEntity(application, entity);
        Task<?> task = this.brooklyn().expunge(instance, release);
        TaskSummary summary = (TaskSummary)TaskTransformer.fromTask(this.ui.getBaseUriBuilder()).apply(task);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)summary).build();
    }

    public List<EntitySummary> getDescendants(String application, String entity, String typeRegex) {
        return EntityTransformer.entitySummaries(this.brooklyn().descendantsOfType(application, entity, typeRegex), this.ui.getBaseUriBuilder());
    }

    public Map<String, Object> getDescendantsSensor(String application, String entity, String sensor, String typeRegex) {
        Iterable<Entity> descs = this.brooklyn().descendantsOfType(application, entity, typeRegex);
        return ApplicationResource.getSensorMap(sensor, descs);
    }

    public List<LocationSummary> getLocations(String application, String entity) {
        ArrayList result = Lists.newArrayList();
        Entity e = this.brooklyn().getEntity(application, entity);
        for (Location l : e.getLocations()) {
            result.add(LocationTransformer.newInstance(this.mgmt(), l, LocationTransformer.LocationDetailLevel.NONE, this.ui.getBaseUriBuilder()));
        }
        return result;
    }

    public String getSpec(String applicationToken, String entityToken) {
        Entity entity = this.brooklyn().getEntity(applicationToken, entityToken);
        BrooklynTags.NamedStringTag spec = BrooklynTags.findFirst((String)"yaml_spec", (Iterable)entity.tags().getTags());
        if (spec == null) {
            return null;
        }
        return (String)WebResourceUtils.getValueForDisplay(spec.getContents(), false, true);
    }

    @Beta
    public static class InterestingTasksFirstComparator
    implements Comparator<Task<?>> {
        Entity context;

        public InterestingTasksFirstComparator() {
            this(null);
        }

        public InterestingTasksFirstComparator(Entity entity) {
            this.context = entity;
        }

        @Override
        public int compare(Task<?> o1, Task<?> o2) {
            long t1;
            if (!Objects.equal((Object)o1.isSubmitted(), (Object)o2.isSubmitted())) {
                return o1.isSubmitted() ? -1 : 1;
            }
            int weight = 0;
            Task o1s = o1.getSubmittedByTask();
            Task o2s = o2.getSubmittedByTask();
            if ("start".equals(o1.getDisplayName()) || "start".equals(o2.getDisplayName())) {
                weight = 0;
            }
            if (!Objects.equal((Object)(o1s == null ? 1 : 0), (Object)(o2s == null ? 1 : 0))) {
                weight += 7200 * (o1s == null ? -1 : 1);
            }
            if (this.context != null && o1s != null && o2s != null) {
                boolean o1se = this.context.equals(BrooklynTaskTags.getContextEntity((Task)o1s));
                boolean o2se = this.context.equals(BrooklynTaskTags.getContextEntity((Task)o2s));
                if (!Objects.equal((Object)o1se, (Object)o2se)) {
                    weight += 600 * (o2se ? -1 : 1);
                }
            }
            if (!Objects.equal((Object)(o1.isBegun() && !o1.isDone() ? 1 : 0), (Object)(o2.isBegun() && !o2.isDone() ? 1 : 0))) {
                weight += 60 * (o1.isBegun() && !o1.isDone() ? -1 : 1);
            }
            if (!Objects.equal((Object)o1.isBegun(), (Object)o2.isBegun())) {
                weight += 10 * (!o1.isBegun() ? -1 : 1);
            }
            long now = System.currentTimeMillis();
            long l = o1.isDone() ? o1.getEndTimeUtc() : (t1 = o1.isBegun() ? o1.getStartTimeUtc() : o1.getSubmitTimeUtc());
            long t2 = o2.isDone() ? o2.getEndTimeUtc() : (o2.isBegun() ? o2.getStartTimeUtc() : o2.getSubmitTimeUtc());
            long u1 = now - t1;
            long u2 = now - t2;
            if (weight < 0) {
                u2 *= (long)(-weight);
            } else if (weight > 0) {
                u1 *= (long)weight;
            }
            if (u1 != u2) {
                return u1 > u2 ? 1 : -1;
            }
            if (weight != 0) {
                return weight < 0 ? -1 : 1;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

