/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import org.apache.brooklyn.util.ssh.BashCommands;

public class IptablesCommands {
    @Beta
    public static String iptablesService(String cmd) {
        return BashCommands.sudo(BashCommands.alternatives(BashCommands.ifExecutableElse1("service", "service iptables " + cmd), "/sbin/service iptables " + cmd));
    }

    @Beta
    public static String iptablesServiceStop() {
        return IptablesCommands.iptablesService("stop");
    }

    @Beta
    public static String iptablesServiceStart() {
        return IptablesCommands.iptablesService("start");
    }

    @Beta
    public static String iptablesServiceRestart() {
        return IptablesCommands.iptablesService("restart");
    }

    @Beta
    public static String iptablesServiceStatus() {
        return IptablesCommands.iptablesService("status");
    }

    @Beta
    public static String firewalldService(String cmd) {
        return BashCommands.sudo(BashCommands.alternatives(BashCommands.ifExecutableElse1("systemctl", "systemctl " + cmd + " firewalld"), "/usr/bin/systemctl " + cmd + " firewalld"));
    }

    @Beta
    public static String firewalldServiceStop() {
        return IptablesCommands.firewalldService("stop");
    }

    @Beta
    public static String firewalldServiceStart() {
        return IptablesCommands.firewalldService("start");
    }

    @Beta
    public static String firewalldServiceRestart() {
        return IptablesCommands.firewalldService("restart");
    }

    @Beta
    public static String firewalldServiceStatus() {
        return IptablesCommands.firewalldService("status");
    }

    @Beta
    public static String firewalldServiceIsActive() {
        return IptablesCommands.firewalldService("is-active");
    }

    public static String saveIptablesRules() {
        return BashCommands.alternatives(BashCommands.sudo("service iptables save"), BashCommands.chain(BashCommands.installPackage("iptables-persistent"), BashCommands.sudo("/etc/init.d/iptables-persistent save")));
    }

    public static String cleanUpIptablesRules() {
        return BashCommands.sudo("/sbin/iptables -F");
    }

    public static String listIptablesRule() {
        return BashCommands.sudo("/sbin/iptables -L -v -n");
    }

    public static String insertIptablesRule(Chain chain, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-I", chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    public static String insertIptablesRule(Chain chain, String networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-I", chain, (Optional<String>)Optional.of((Object)networkInterface), protocol, port, policy);
    }

    public static String appendIptablesRule(Chain chain, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-A", chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    public static String appendIptablesRule(Chain chain, String networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-A", chain, (Optional<String>)Optional.of((Object)networkInterface), protocol, port, policy);
    }

    public static String addIptablesRule(String direction, Chain chain, Optional<String> networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        String addIptablesRule = networkInterface.isPresent() ? String.format("/sbin/iptables %s %s -i %s -p %s --dport %d -j %s", new Object[]{direction, chain, networkInterface.get(), protocol, port, policy}) : String.format("/sbin/iptables %s %s -p %s --dport %d -j %s", new Object[]{direction, chain, protocol, port, policy});
        return BashCommands.sudo(addIptablesRule);
    }

    public static String addFirewalldRule(Chain chain, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addFirewalldRule(chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    public static String addFirewalldRule(Chain chain, Optional<String> networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        String command = new String("/usr/bin/firewall-cmd");
        String commandPermanent = new String("/usr/bin/firewall-cmd --permanent");
        String interfaceParameter = String.format("%s", networkInterface.isPresent() ? " -i " + (String)networkInterface.get() : "");
        String commandParameters = String.format(" --direct --add-rule ipv4 filter %s 0 %s -p %s --dport %d -j %s", new Object[]{chain, interfaceParameter, protocol, port, policy});
        return BashCommands.sudo(BashCommands.chain(command + commandParameters, commandPermanent + commandParameters));
    }

    @Deprecated
    public static enum Protocol {
        TCP("tcp"),
        UDP("udp"),
        ALL("all");

        final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String toString() {
            return this.protocol;
        }

        org.apache.brooklyn.util.net.Protocol convert() {
            switch (this) {
                case TCP: {
                    return org.apache.brooklyn.util.net.Protocol.TCP;
                }
                case UDP: {
                    return org.apache.brooklyn.util.net.Protocol.UDP;
                }
                case ALL: {
                    return org.apache.brooklyn.util.net.Protocol.ALL;
                }
            }
            throw new IllegalStateException("Unexpected protocol " + (Object)((Object)this));
        }
    }

    public static enum Policy {
        ACCEPT,
        REJECT,
        DROP,
        LOG;

    }

    public static enum Chain {
        INPUT,
        FORWARD,
        OUTPUT;

    }
}

