/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

public class Configuration {
    private final String id;
    private final String label;
    private final String description;

    public static Builder builder() {
        return new Builder();
    }

    public Configuration(String id, String label, String description) {
        this.id = id;
        this.label = label;
        this.description = description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.format("[id=%s, label=%s, description=%s]", this.id, this.label, this.description);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public static class Builder {
        protected String id;
        protected String label;
        protected String description;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.id, this.label, this.description);
        }

        public Builder fromConfiguration(Configuration in) {
            return this.id(in.getId()).description(in.getDescription()).label(in.getLabel());
        }
    }
}

