/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

import java.net.URI;

public class Disk
implements Comparable<Disk> {
    private final String id;
    private final Long capacity;
    private final String parentRef;
    private final String fileRef;
    private final URI format;
    private final Long populatedSize;
    private final String capacityAllocationUnits;

    public static Builder builder() {
        return new Builder();
    }

    public Disk(String id, Long capacity, String parentRef, String fileRef, URI format, Long populatedSize, String capacityAllocationUnits) {
        this.id = id;
        this.capacity = capacity;
        this.parentRef = parentRef;
        this.fileRef = fileRef;
        this.format = format;
        this.populatedSize = populatedSize;
        this.capacityAllocationUnits = capacityAllocationUnits;
    }

    public String getId() {
        return this.id;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public String getParentRef() {
        return this.parentRef;
    }

    public String getFileRef() {
        return this.fileRef;
    }

    public URI getFormat() {
        return this.format;
    }

    public Long getPopulatedSize() {
        return this.populatedSize;
    }

    public String getCapacityAllocationUnits() {
        return this.capacityAllocationUnits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disk other = (Disk)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.format("[id=%s, capacity=%s, capacityAllocationUnits=%s, fileRef=%s, format=%s, parentRef=%s, populatedSize=%s]", this.id, this.capacity, this.capacityAllocationUnits, this.fileRef, this.format, this.parentRef, this.populatedSize);
    }

    @Override
    public int compareTo(Disk o) {
        if (this.id == null) {
            return -1;
        }
        return this == o ? 0 : this.id.compareTo(o.id);
    }

    public static class Builder {
        private String id;
        private Long capacity;
        private String parentRef;
        private String fileRef;
        private URI format;
        private Long populatedSize;
        private String capacityAllocationUnits;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder parentRef(String parentRef) {
            this.parentRef = parentRef;
            return this;
        }

        public Builder fileRef(String fileRef) {
            this.fileRef = fileRef;
            return this;
        }

        public Builder format(URI format) {
            this.format = format;
            return this;
        }

        public Builder populatedSize(Long populatedSize) {
            this.populatedSize = populatedSize;
            return this;
        }

        public Builder capacityAllocationUnits(String capacityAllocationUnits) {
            this.capacityAllocationUnits = capacityAllocationUnits;
            return this;
        }

        public Disk build() {
            return new Disk(this.id, this.capacity, this.parentRef, this.fileRef, this.format, this.populatedSize, this.capacityAllocationUnits);
        }

        public Builder fromDisk(Disk in) {
            return this.id(in.getId()).capacity(in.getCapacity()).parentRef(in.getParentRef()).fileRef(in.getFileRef()).format(in.getFormat()).populatedSize(in.getPopulatedSize()).capacityAllocationUnits(in.getCapacityAllocationUnits());
        }
    }
}

