/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.config.NamespaceAliases;
import org.jclouds.openstack.keystone.v2_0.handlers.KeystoneErrorHandler;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.functions.PresentWhenExtensionAnnotationMatchesExtensionSet;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

@ConfiguresHttpApi
public class KeystoneHttpApiModule
extends HttpApiModule<KeystoneApi> {
    public static MapBinder<URI, URI> namespaceAliasBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, URI.class, URI.class, NamespaceAliases.class).permitDuplicates();
    }

    protected void configure() {
        this.bind(ImplicitOptionalConverter.class).to(PresentWhenExtensionAnnotationMatchesExtensionSet.class);
        super.configure();
        KeystoneHttpApiModule.namespaceAliasBinder(this.binder());
    }

    @Provides
    @Singleton
    public final LoadingCache<String, Set<? extends Extension>> provideExtensionsByRegion(final Provider<KeystoneApi> keystoneApi) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from((Supplier)Suppliers.memoize((Supplier)new Supplier<Set<? extends Extension>>(){

            public Set<? extends Extension> get() {
                return ((KeystoneApi)keystoneApi.get()).getExtensionApi().list();
            }
        })));
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(KeystoneErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(KeystoneErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(KeystoneErrorHandler.class);
    }
}

