/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.ha.BrooklynBomOsgiArchiveInstaller;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.typereg.BrooklynCatalogBundleResolver;
import org.apache.brooklyn.core.typereg.UnsupportedCatalogBundleException;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.stream.InputStreamSource;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynCatalogBundleResolvers {
    private static Logger LOG = LoggerFactory.getLogger(BrooklynCatalogBundleResolvers.class);
    private static Collection<Class<? extends BrooklynCatalogBundleResolver>> OVERRIDE;

    private static Collection<BrooklynCatalogBundleResolver> getAll() {
        return ImmutableList.copyOf((Iterable)FrameworkLookup.lookupAll(BrooklynCatalogBundleResolver.class));
    }

    @SafeVarargs
    @VisibleForTesting
    public static synchronized void forceAvailable(Class<? extends BrooklynCatalogBundleResolver> ... classes) {
        OVERRIDE = Arrays.asList(classes);
    }

    public static synchronized void clearForced() {
        OVERRIDE = null;
    }

    public static Collection<BrooklynCatalogBundleResolver> all(ManagementContext mgmt) {
        Collection<Class<? extends BrooklynCatalogBundleResolver>> override = OVERRIDE;
        ArrayList<BrooklynCatalogBundleResolver> result = new ArrayList<BrooklynCatalogBundleResolver>();
        if (override != null) {
            for (Class<? extends BrooklynCatalogBundleResolver> o1 : override) {
                try {
                    result.add(o1.newInstance());
                }
                catch (Exception e) {
                    Exceptions.propagate((Throwable)e);
                }
            }
        } else {
            result.addAll(BrooklynCatalogBundleResolvers.getAll());
        }
        for (BrooklynCatalogBundleResolver t : result) {
            t.setManagementContext(mgmt);
        }
        return result;
    }

    public static Map<BrooklynCatalogBundleResolver, Double> forBundleWithScore(ManagementContext mgmt, Supplier<InputStream> input, BrooklynCatalogBundleResolver.BundleInstallationOptions options) {
        TreeMultimap byScoreMulti = TreeMultimap.create(Comparator.reverseOrder(), (r1, r2) -> 0);
        Collection<BrooklynCatalogBundleResolver> resolvers = BrooklynCatalogBundleResolvers.all(mgmt);
        for (BrooklynCatalogBundleResolver transformer : resolvers) {
            double score = transformer.scoreForBundle(options == null ? null : options.format, input);
            if (LOG.isTraceEnabled()) {
                LOG.trace("SCORE for '" + input + "' at " + transformer + ": " + score);
            }
            if (!(score > 0.0)) continue;
            byScoreMulti.put((Object)score, (Object)transformer);
        }
        return (Map)byScoreMulti.entries().stream().collect(MutableMap::new, (map, entry) -> {
            Double cfr_ignored_0 = (Double)map.put(entry.getValue(), entry.getKey());
        }, (x, y) -> {
            throw new IllegalStateException();
        });
    }

    public static List<BrooklynCatalogBundleResolver> forBundle(ManagementContext mgmt, Supplier<InputStream> input, BrooklynCatalogBundleResolver.BundleInstallationOptions options) {
        return MutableList.copyOf(BrooklynCatalogBundleResolvers.forBundleWithScore(mgmt, input, options).keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceWithError<OsgiBundleInstallationResult> install(ManagementContext mgmt, Supplier<InputStream> input, BrooklynCatalogBundleResolver.BundleInstallationOptions options) {
        RuntimeException exception;
        MutableMap failuresFromResolvers;
        Map<BrooklynCatalogBundleResolver, Double> resolvers;
        block25: {
            LOG.debug("Installing bundle {} / {} for {}", new Object[]{input, options == null ? null : options.knownBundleMetadata, Entitlements.getEntitlementContextUser()});
            BrooklynBomOsgiArchiveInstaller.PrepareInstallResult prepareResult = null;
            if (input == null && options.knownBundleMetadata == null) {
                return ReferenceWithError.newInstanceThrowingError(null, (Throwable)new IllegalArgumentException("Bundle contents or reference must be supplied"));
            }
            if (input == null && options.knownBundleMetadata != null) {
                try {
                    prepareResult = BrooklynBomOsgiArchiveInstaller.prepareInstall(mgmt, options.knownBundleMetadata, null, input, options.forceUpdateOfNonSnapshots, null);
                    if (prepareResult.resultObject != null) {
                        return ReferenceWithError.newInstanceWithoutError((Object)prepareResult.resultObject);
                    }
                    if (prepareResult.zipFile == null) {
                        return ReferenceWithError.newInstanceThrowingError(null, (Throwable)new IllegalArgumentException("Bundle contents or known reference must be supplied; " + options.knownBundleMetadata + " not known"));
                    }
                    input = InputStreamSource.of((String)prepareResult.zipFile.getFile().getName(), (File)prepareResult.zipFile.getFile());
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    return ReferenceWithError.newInstanceThrowingError(null, (Throwable)e);
                }
            }
            OsgiBundleInstallationResult firstResult = null;
            try {
                resolvers = BrooklynCatalogBundleResolvers.forBundleWithScore(mgmt, input, options);
                ArrayList<String> resolversWhoDontSupport = new ArrayList<String>();
                failuresFromResolvers = MutableMap.of();
                Double highestFailedScore = null;
                for (Map.Entry<BrooklynCatalogBundleResolver, Double> ti : resolvers.entrySet()) {
                    BrooklynCatalogBundleResolver t = ti.getKey();
                    try {
                        ReferenceWithError<OsgiBundleInstallationResult> result = t.install((Supplier<InputStream>)input, options);
                        if (result == null) {
                            resolversWhoDontSupport.add(t.getFormatCode() + " (returned null)");
                            continue;
                        }
                        if (firstResult == null) {
                            firstResult = (OsgiBundleInstallationResult)result.getWithoutError();
                        }
                        result.get();
                        LOG.debug("Installed bundle {} / {} for {}: {}: {}", new Object[]{input, options == null ? null : options.knownBundleMetadata, Entitlements.getEntitlementContextUser(), ((OsgiBundleInstallationResult)result.get()).getCode(), ((OsgiBundleInstallationResult)result.get()).getMessage()});
                        if (highestFailedScore != null) {
                            if (highestFailedScore > 0.9 && (ti.getValue() == null || highestFailedScore > ti.getValue() + 0.1)) {
                                LOG.warn("Bundle {} was installed by fallback resolver {} because preferred resolver(s) reported issues: {} / {} (scores {})", new Object[]{t, ((OsgiBundleInstallationResult)result.get()).getMetadata(), resolversWhoDontSupport, failuresFromResolvers, resolvers});
                            } else {
                                LOG.debug("Bundle {} was installed by resolver {} after other resolver(s) reported issues: {} / {} (scores {})", new Object[]{t, ((OsgiBundleInstallationResult)result.get()).getMetadata(), resolversWhoDontSupport, failuresFromResolvers, resolvers});
                            }
                        }
                        ReferenceWithError<OsgiBundleInstallationResult> referenceWithError = result;
                        return referenceWithError;
                    }
                    catch (UnsupportedCatalogBundleException e) {
                        resolversWhoDontSupport.add(t.getFormatCode() + (Strings.isNonBlank((CharSequence)e.getMessage()) ? " (" + e.getMessage() + ")" : ""));
                    }
                    catch (Throwable e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Resolver for " + t.getFormatCode() + " gave an error creating this plan (may retry): " + e, e);
                        }
                        failuresFromResolvers.put(t, new PropagatedRuntimeException(t.getFormatCode() + " bundle installation error" + ": " + Exceptions.collapseText((Throwable)e), e));
                    }
                    {
                        if (highestFailedScore != null) continue;
                        highestFailedScore = ti.getValue();
                    }
                }
                if (!LOG.isDebugEnabled()) break block25;
                LOG.debug("Failure resolving bundle; returning summary failure, but for reference potentially applicable resolvers were " + resolvers + " (available ones are " + MutableList.builder().addAll(BrooklynCatalogBundleResolvers.all(mgmt)).build() + ")" + (failuresFromResolvers.isEmpty() ? "" : "; failures: " + failuresFromResolvers) + (resolversWhoDontSupport.isEmpty() ? "" : "; unsupported by: " + resolversWhoDontSupport) + (firstResult == null ? "" : "; error result: " + firstResult));
            }
            catch (Exception e) {
                ReferenceWithError referenceWithError = ReferenceWithError.newInstanceThrowingError(null, (Throwable)e);
                return referenceWithError;
            }
            finally {
                if (prepareResult != null && prepareResult.zipFile != null) {
                    prepareResult.zipFile.deleteIfTemp();
                }
            }
        }
        if (!failuresFromResolvers.isEmpty()) {
            Double score = resolvers.get(failuresFromResolvers.keySet().iterator().next());
            double minScore = score == null ? 0.0 : score / 2.0;
            List interestingFailures = failuresFromResolvers.entrySet().stream().filter(entry -> (Double)Maybe.ofDisallowingNull(resolvers.get(entry.getKey())).or((Object)0.0) > minScore).map(entry -> (Exception)entry.getValue()).collect(Collectors.toList());
            exception = interestingFailures.size() == 1 ? Exceptions.create(null, interestingFailures) : Exceptions.create((String)"All applicable bundle resolvers failed", interestingFailures);
        } else {
            String prefix = Strings.isBlank((CharSequence)options.format) ? "Invalid bundle" : "Invalid '" + options.format + "' bundle";
            exception = resolvers.isEmpty() ? new UnsupportedTypePlanException(prefix + "; format could not be recognized, none of the available resolvers " + BrooklynCatalogBundleResolvers.all(mgmt) + " support it") : new UnsupportedTypePlanException(prefix + "; potentially applicable resolvers " + resolvers + " do not support it, and other available resolvers do not accept it");
        }
        ReferenceWithError referenceWithError = ReferenceWithError.newInstanceThrowingError(null, (Throwable)exception);
        return referenceWithError;
    }
}

