/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.util.Throwables2;

@Beta
public final class FunctionalReflection {
    public static <T> T newProxy(TypeToken<T> enclosingType, Function<Invocation, Object> invocationFunction) {
        Preconditions.checkNotNull(enclosingType, (Object)"enclosingType");
        Preconditions.checkNotNull(invocationFunction, (Object)"invocationFunction");
        return FunctionalReflection.newProxy(enclosingType.getRawType(), new FunctionalInvocationHandler(enclosingType, invocationFunction));
    }

    public static <T> T newProxy(Class<T> enclosingType, Function<Invocation, Object> invocationFunction) {
        Preconditions.checkNotNull(invocationFunction, (Object)"invocationFunction");
        return FunctionalReflection.newProxy(enclosingType, new FunctionalInvocationHandler(Reflection2.typeToken(enclosingType), invocationFunction));
    }

    private static <T> T newProxy(Class<? super T> enclosingType, FunctionalInvocationHandler<T> invocationHandler) {
        Preconditions.checkNotNull(enclosingType, (Object)"enclosingType");
        Preconditions.checkArgument((boolean)enclosingType.isInterface(), (String)"%s is not an interface", enclosingType);
        return (T)Proxy.newProxyInstance(enclosingType.getClassLoader(), new Class[]{enclosingType}, invocationHandler);
    }

    private static final class FunctionalInvocationHandler<T>
    extends AbstractInvocationHandler {
        private final TypeToken<T> enclosingType;
        private final Function<Invocation, Object> invocationFunction;

        private FunctionalInvocationHandler(TypeToken<T> enclosingType, Function<Invocation, Object> invocationFunction) {
            this.enclosingType = enclosingType;
            this.invocationFunction = invocationFunction;
        }

        protected Object handleInvocation(Object proxy, Method invoked, Object[] argv) throws Throwable {
            Object args = Arrays.asList(argv);
            args = Iterables.all(args, (Predicate)Predicates.notNull()) ? ImmutableList.copyOf(args) : Collections.unmodifiableList(args);
            Invokable invokable = Reflection2.method(this.enclosingType, invoked);
            Invocation invocation = Invocation.create(invokable, (List<Object>)args);
            try {
                return this.invocationFunction.apply((Object)invocation);
            }
            catch (RuntimeException e) {
                Throwables2.propagateIfPossible(e, (Iterable<TypeToken<? extends Throwable>>)invocation.getInvokable().getExceptionTypes());
                throw Throwables.propagate((Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            FunctionalInvocationHandler that = (FunctionalInvocationHandler)((Object)FunctionalInvocationHandler.class.cast(o));
            return Objects.equal(this.enclosingType, that.enclosingType) && Objects.equal(this.invocationFunction, that.invocationFunction);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.enclosingType, this.invocationFunction});
        }

        public String toString() {
            return this.invocationFunction.toString();
        }
    }
}

