/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public class TenantIdAndName {
    @Named(value="tenant_id")
    private final String tenantId;
    private final String name;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTenantIdAndName(this);
    }

    @ConstructorProperties(value={"tenant_id", "name"})
    protected TenantIdAndName(String tenantId, String name) {
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tenantId, this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TenantIdAndName that = (TenantIdAndName)TenantIdAndName.class.cast(obj);
        return Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal((Object)this.name, (Object)that.name);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("name", (Object)this.name);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String tenantId;
        protected String name;

        protected abstract T self();

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public TenantIdAndName build() {
            return new TenantIdAndName(this.tenantId, this.name);
        }

        public T fromTenantIdAndName(TenantIdAndName in) {
            return ((Builder)this.tenantId(in.getTenantId())).name(in.getName());
        }
    }
}

