/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.metadata.registry.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.ui.modularity.metadata.registry.UiMetadataRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.apache.brooklyn.ui.modularity.metadata"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"type:String=generic"})
public class UiMetadataConfigListener {
    static final String PID = "org.apache.brooklyn.ui.modularity.metadata";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.apache.brooklyn.ui.modularity.metadata");
    private static final List<String> EXCLUDE = Arrays.asList("felix.fileinstall.filename", "service.factoryPid", "component.name", "component.id");
    @Reference
    private UiMetadataRegistry metadataRegistry;

    protected String getId(Map<String, String> properties) {
        return properties.containsKey("id") ? properties.get("id") : properties.get("service.pid");
    }

    @Activate
    public void activate(Map<String, String> properties) {
        logger.debug("Activate " + this + ": " + properties);
        if (this.getId(properties) == null) {
            logger.debug("Skipping recording of metadata config for irrelevant activation record: " + properties);
        } else {
            this.modified(properties);
        }
    }

    @Modified
    public void modified(Map<String, String> properties) {
        logger.debug("Modified " + this + ": " + properties);
        String id = this.getId(properties);
        if (id == null) {
            logger.warn("Skipping update of UI metadata because ID is not specified: " + properties);
            return;
        }
        this.metadataRegistry.modifyMetadata(properties.containsKey("type") ? properties.get("type") : "generic", id, Maps.filterKeys(properties, (Predicate)Predicates.not((Predicate)Predicates.in(EXCLUDE))));
    }

    @Deactivate
    public void deactivate(Map<String, String> properties) {
        logger.debug("Deactivate " + this + ": " + properties);
        String id = this.getId(properties);
        if (id == null) {
            logger.debug("Skipping deactivation of UI metadata because ID is not specified: " + properties);
            return;
        }
        this.metadataRegistry.unregisterMetadata(properties.containsKey("type") ? properties.get("type") : "generic", id);
    }
}

