/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.config;

import com.google.common.base.Supplier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.jclouds.azurecompute.arm.config.Tenant;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
@Qualifier
public @interface GraphRBAC {
    public static final String STANDARD_ENDPOINT = "https://graph.windows.net/";
    public static final String CHINA_ENDPOINT = "https://graph.chinacloudapi.cn/";

    public static class GraphRBACForTenant
    implements Supplier<URI> {
        private final String tenantId;
        private final boolean isChinaEndpoint;

        @Inject
        GraphRBACForTenant(@Tenant String tenantId, @Named(value="jclouds.isChinaEndpoint") boolean isChinaEndpoint) {
            this.tenantId = tenantId;
            this.isChinaEndpoint = isChinaEndpoint;
        }

        public URI get() {
            return URI.create((this.isChinaEndpoint ? GraphRBAC.CHINA_ENDPOINT : GraphRBAC.STANDARD_ENDPOINT) + this.tenantId);
        }
    }
}

