/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.informers.cache.Indexer;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface Cache<T>
extends Indexer<T> {
    public static final String NAMESPACE_INDEX = "namespace";

    public static String metaNamespaceKeyFunc(HasMetadata obj) {
        if (obj == null) {
            return "";
        }
        ObjectMeta metadata = obj.getMetadata();
        if (metadata == null) {
            throw new RuntimeException("Object is bad :" + obj);
        }
        return Cache.namespaceKeyFunc(metadata.getNamespace(), metadata.getName());
    }

    public static String metaUidKeyFunc(HasMetadata obj) {
        if (obj == null || obj.getMetadata() == null) {
            return "";
        }
        String result = obj.getMetadata().getUid();
        return Utils.getNonNullOrElse(result, "");
    }

    public static String namespaceKeyFunc(String objectNamespace, String objectName) {
        if (Utils.isNullOrEmpty(objectNamespace)) {
            return objectName;
        }
        return objectNamespace + "/" + objectName;
    }

    public static List<String> metaNamespaceIndexFunc(HasMetadata obj) {
        return Optional.ofNullable(obj).map(HasMetadata::getMetadata).map(metadata -> Collections.singletonList(metadata.getNamespace())).orElse(Collections.emptyList());
    }
}

